package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;

import javax.xml.namespace.QName;
import java.util.Optional;

public class DefaultErrorMatcher implements ErrorMatcher {

  private final Optional<QName> errorCodeQName;

  public DefaultErrorMatcher(String errorCode) {
    this.errorCodeQName = ErrorHandlingUtils.createErrorCode(errorCode);
  }

  @Override
  public boolean matches(ErrorModel errorModel) {
    return errorCodeQName.isPresent() && ErrorHandlingUtils.getErrorCodes(errorModel).contains(errorCodeQName.get());
  }
}
