package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.datasense.impl.util.Utils;
import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.Optional;

import static java.util.Optional.empty;
import static org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils.createErrorMatcher;
import static org.mule.datasense.impl.util.Utils.isNullOrEmpty;

public class ErrorMapping {

  private final ErrorMatcher errorMatcher;
  private final ErrorModel errorModel;

  public ErrorMapping(ErrorMatcher errorMatcher, ErrorModel errorModel) {
    this.errorMatcher = errorMatcher;
    this.errorModel = errorModel;
  }

  private ErrorMatcher getErrorMatcher() {
    return errorMatcher;
  }

  public ErrorModel getErrorModel() {
    return errorModel;
  }

  public boolean matches(ErrorModel errorModel) {
    return getErrorMatcher().matches(errorModel);
  }

  public static Optional<ErrorMapping> create(String sourceType, String targetType) {
    if (isNullOrEmpty(sourceType) || isNullOrEmpty(targetType)) {
      return empty();
    }

    final ErrorMatcher errorMatcher = createErrorMatcher(sourceType);
    return ErrorHandlingUtils.createErrorModel(targetType).map(errorModel -> new ErrorMapping(errorMatcher, errorModel));
  }
}
