/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;

public class TypeEquivalence {
    public static boolean canBeAssignedTo(MetadataType assignmentType, MetadataType expectedType, Optional<TypeParametersContext> ctx) {
        boolean result;
        if (assignmentType instanceof UnionType) {
            UnionType assignmentUnionType = (UnionType)assignmentType;
            List of = assignmentUnionType.getTypes();
            result = !of.stream().anyMatch(t -> !TypeEquivalence.canBeAssignedTo(t, expectedType, Optional.empty()));
        } else if (assignmentType instanceof NothingType) {
            result = true;
        } else if (expectedType instanceof ObjectType) {
            ObjectType expectedObjectType = (ObjectType)expectedType;
            Collection expectedProperties = expectedObjectType.getFields();
            if (assignmentType instanceof ObjectType) {
                ObjectType assignmentObjectType = (ObjectType)assignmentType;
                Collection assignedProperties = assignmentObjectType.getFields();
                result = !expectedProperties.stream().anyMatch(expectedProperty -> expectedProperty.isRequired() && !assignedProperties.stream().anyMatch(assignedProperty -> TypeEquivalence.canBeAssignedTo((MetadataType)assignedProperty, (MetadataType)expectedProperty, ctx)));
            } else {
                result = false;
            }
        } else if (expectedType instanceof ObjectFieldType) {
            ObjectFieldType assignmentObjectFieldType;
            boolean optional;
            ObjectFieldType expectedObjectFieldType = (ObjectFieldType)expectedType;
            ObjectKeyType expectedKey = expectedObjectFieldType.getKey();
            MetadataType expectedValue = expectedObjectFieldType.getValue();
            boolean bl = optional = !expectedObjectFieldType.isRequired();
            result = assignmentType instanceof ObjectFieldType ? TypeEquivalence.canBeAssignedTo((MetadataType)(assignmentObjectFieldType = (ObjectFieldType)assignmentType).getKey(), (MetadataType)expectedKey, ctx) && TypeEquivalence.canBeAssignedTo(assignmentObjectFieldType.getValue(), expectedValue, ctx) : false;
        } else if (expectedType instanceof ObjectKeyType) {
            ObjectKeyType assignedKey;
            ObjectKeyType expectedObjectKeyType = (ObjectKeyType)expectedType;
            QName expectedName = expectedObjectKeyType.getName();
            Collection expectedAttributes = expectedObjectKeyType.getAttributes();
            result = assignmentType instanceof ObjectKeyType ? (assignedKey = (ObjectKeyType)assignmentType).getName().equals(expectedName) && !expectedAttributes.stream().anyMatch(expectedAttr -> !assignedKey.getAttributes().stream().anyMatch(assignedAttr -> TypeEquivalence.canBeAssignedTo((MetadataType)assignedAttr, (MetadataType)expectedAttr, ctx))) : false;
        } else if (expectedType instanceof ArrayType) {
            ArrayType expectedArrayType = (ArrayType)expectedType;
            MetadataType expectedItemType = expectedArrayType.getType();
            if (assignmentType instanceof ArrayType) {
                ArrayType assignmentArrayType = (ArrayType)assignmentType;
                MetadataType assignmentItemType = assignmentArrayType.getType();
                result = TypeEquivalence.canBeAssignedTo(assignmentItemType, expectedItemType, ctx);
            } else {
                result = false;
            }
        } else if (expectedType instanceof UnionType) {
            List assignedTypes;
            List expectedTypes = ((UnionType)expectedType).getTypes();
            result = assignmentType instanceof UnionType ? !(assignedTypes = ((UnionType)assignmentType).getTypes()).stream().anyMatch(actualType -> !expectedTypes.stream().anyMatch(innerExpectedType -> TypeEquivalence.canBeAssignedTo(actualType, innerExpectedType, ctx))) : expectedTypes.stream().anyMatch(wtype -> TypeEquivalence.canBeAssignedTo(assignmentType, wtype, ctx));
        } else if (expectedType instanceof TypeParameterType) {
            TypeParameterType expectedTypeParameterType = (TypeParameterType)expectedType;
            String name = expectedTypeParameterType.getName();
            result = false;
        } else {
            result = expectedType instanceof FunctionType ? false : (expectedType instanceof AnyType ? true : (expectedType instanceof StringType ? assignmentType instanceof StringType : (expectedType instanceof BooleanType ? assignmentType instanceof BooleanType : (expectedType instanceof NumberType ? assignmentType instanceof NumberType : (expectedType instanceof DateTimeType ? assignmentType instanceof DateTimeType : (expectedType instanceof LocalDateTimeType ? assignmentType instanceof LocalDateTimeType : (expectedType instanceof LocalTimeType ? assignmentType instanceof LocalTimeType : (expectedType instanceof TimeType ? assignmentType instanceof TimeType : (expectedType instanceof TimeZoneType ? assignmentType instanceof TimeZoneType : (expectedType instanceof PeriodType ? assignmentType instanceof PeriodType : (expectedType instanceof BinaryType ? assignmentType instanceof BinaryType : (expectedType instanceof RegexType ? assignmentType instanceof RegexType : (expectedType instanceof NullType ? assignmentType instanceof NullType : false)))))))))))));
        }
        return result;
    }

    private static class TypeParametersContext {
        Map<String, MetadataType> context = new HashMap<String, MetadataType>();

        public Optional<MetadataType> get(String name) {
            return Optional.ofNullable(this.context.get(name));
        }
    }
}

