/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.tooling.TypeInfoQueryResult;
import org.mule.datasense.impl.tooling.TypedApplicationQuery;
import org.mule.datasense.impl.util.bindings.TypeBindingUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;

public class TypeInfoQuery
implements TypedApplicationQuery<TypeInfoQueryResult> {
    private final Location location;

    public TypeInfoQuery(Location location) {
        this.location = location;
    }

    @Override
    public Optional<TypeInfoQueryResult> perform(MuleApplicationNode muleApplicationNode, DataSenseProviderResolver dataSenseProviderResolver, AstNotification astNotification) {
        return muleApplicationNode.findMessageProcessorNode(this.location).map(messageProcessorNode -> new TypeInfoQueryResult((MetadataType)TypeUtils.asMuleEventMetadataType(messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).map(UsesTypeAnnotation::getUsesEventType).orElse(new EventType())).build(), (MetadataType)TypeUtils.asMuleEventMetadataType(messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType())).build()));
    }

    public static Map<String, MetadataType> getGlobalTypeBindings(MuleApplicationNode muleApplicationNode) {
        return muleApplicationNode.getAnnotation(GlobalBindingsAnnotation.class).map(GlobalBindingsAnnotation::getTypeBindings).map(typeBindings -> TypeBindingUtils.toMap(typeBindings)).orElse(Collections.emptyMap());
    }

    public static Map<String, MetadataType> getFunctionBindings(MuleApplicationNode muleApplicationNode) {
        return muleApplicationNode.getAnnotation(FunctionBindingsAnnotation.class).map(FunctionBindingsAnnotation::getFunctionBindings).map(typeBindings -> TypeBindingUtils.toMap(typeBindings)).orElse(Collections.emptyMap());
    }
}

