package org.mule.datasense.api.metadataprovider;

import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class DefaultApplicationModel implements ApplicationModel {

  private final String name;
  private final ArtifactAst applicationModel;
  private final List<String> typesDataList;
  private final Function<String, Optional<URI>> resourceResolver;

  public DefaultApplicationModel(String name,
                                 ArtifactAst applicationModel) {
    this(name, applicationModel, null);
  }

  public DefaultApplicationModel(String name,
                                 ArtifactAst applicationModel,
                                 String typesData) {
    this(name, applicationModel, Collections.singletonList(typesData), null);
  }

  public DefaultApplicationModel(String name,
                                 ArtifactAst applicationModel,
                                 List<String> typesDataList,
                                 Function<String, Optional<URI>> resourceResolver) {
    this.name = name;
    this.applicationModel = applicationModel;
    this.typesDataList = new ArrayList<>();
    this.typesDataList.addAll(typesDataList);
    this.resourceResolver = resourceResolver;
  }

  public String getName() {
    return name;
  }

  @Override
  public ArtifactAst getMuleApplicationModel() {
    return applicationModel;
  }

  @Override
  public Optional<ComponentAst> findNamedComponent(String name) {
    return getMuleApplicationModel()
        .topLevelComponentsStream()
        .filter(comp -> name.equals(comp.getComponentId().orElse(null)))
        .findFirst();
  }

  @Override
  public List<String> findTypesDataList() {
    return typesDataList;
  }

  public Optional<Function<String, Optional<URI>>> getResourceResolver() {
    return Optional.ofNullable(resourceResolver);
  }

  @Override
  public Optional<URI> findResource(String resource) {
    return getResourceResolver().map(resourceResolver -> resourceResolver.apply(resource)).orElse(Optional.empty());
  }
}
