package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.types.EventType;

public class IncomingEventAnnotation implements AstNodeAnnotation {

  private final EventType eventType;

  public IncomingEventAnnotation(EventType eventType) {
    Preconditions.checkNotNull(eventType);
    this.eventType = eventType;
  }

  public EventType getEventType() {
    return eventType;
  }
}
