package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.types.EventType;

public class ResultEventAnnotation implements AstNodeAnnotation {

  private EventType resultEventType;

  public ResultEventAnnotation(EventType resultEventType) {
    Preconditions.checkNotNull(resultEventType);
    this.resultEventType = resultEventType;
  }

  public EventType getResultEventType() {
    return resultEventType;
  }
}
