/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.model.types;

import org.mule.runtime.api.component.location.ComponentLocation;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 *
 */
public class VarDeclMetadata {

  private final ComponentLocation componentLocation;

  public VarDeclMetadata(ComponentLocation componentLocation) {
    this.componentLocation = componentLocation;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    VarDeclMetadata that = (VarDeclMetadata) o;

    return componentLocation.equals(that.componentLocation);
  }

  @Override
  public int hashCode() {
    return componentLocation.hashCode();
  }

  public Optional<ComponentLocation> getComponentLocation() {
    return ofNullable(componentLocation);
  }
}
