package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessage;

public abstract class BaseAnnotator implements Annotator {

  protected void reportError(I18nMessage message, MessageProcessorNode messageProcessorNode,
                             AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    annotatingMuleAstVisitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), message);
  }
}
