package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.metadata.message.api.el.TypeBindings;

public class GlobalBindingsAnnotator implements Annotator {

  @Override
  public void annotate(MuleApplicationNode muleApplicationNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    registerGlobalBindings(muleApplicationNode, annotatingMuleAstVisitorContext);
  }

  private void registerGlobalBindings(MuleApplicationNode muleApplicationNode, AnnotatingMuleAstVisitorContext visitorContext) {
    final TypeBindings.Builder typeBindingsBuilder = TypeBindings.builder();

    final GlobalBindingMetadataTypes globalBindingMetadataTypes =
        visitorContext.getDataSenseProviderResolver().getGlobalBindingMetadataTypes();

    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_MULE, globalBindingMetadataTypes.muleType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_SERVER, globalBindingMetadataTypes.serverType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_APP, globalBindingMetadataTypes.appType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_FLOW, globalBindingMetadataTypes.flowType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_CORRELATION_ID, globalBindingMetadataTypes.correlationIdType());
    typeBindingsBuilder.addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_AUTHENTICATION,
                                   globalBindingMetadataTypes.authenticationType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_DATA_TYPE, globalBindingMetadataTypes.dataTypeType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_ITEM_SEQUENCE_INFO,
                    globalBindingMetadataTypes.itemSequenceInfoType());
    typeBindingsBuilder
        .addBinding(GlobalBindingMetadataTypes.GLOBAL_BINDING_ERROR, globalBindingMetadataTypes.errorType());
    final TypeBindings typeBindings = typeBindingsBuilder.build();

    muleApplicationNode.annotate(new GlobalBindingsAnnotation(globalBindingMetadataTypes, typeBindings));
  }
}
