package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.ArrayList;
import java.util.List;

public class CompositeErrorMatcher implements ErrorMatcher {

  private final List<ErrorMatcher> errorMatchers;

  public CompositeErrorMatcher(List<ErrorMatcher> errorMatchers) {
    this.errorMatchers = new ArrayList<>();
    this.errorMatchers.addAll(errorMatchers);
  }

  @Override
  public boolean matches(ErrorModel errorModel) {
    return errorMatchers.stream().anyMatch(errorMatcher -> errorMatcher.matches(errorModel));
  }
}
