package org.mule.datasense.impl.phases.typing.resolver.munit;

import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SetDataTypeResolver;

import java.util.function.Consumer;

public class MUnitSetEventTypeResolver extends SetDataTypeResolver {

  private static final String ATTR_CLONE_ORIGINAL_EVENT = "cloneOriginalEvent";

  private final MUnitSetEventParser mUnitSetEventParser;

  public MUnitSetEventTypeResolver() {
    mUnitSetEventParser = new MUnitSetEventParser();
  }

  @Override
  protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode,
                                                                           EventType inputEventType,
                                                                           TypingMuleAstVisitor typingMuleAstVisitor,
                                                                           TypingMuleAstVisitorContext visitorContext) {

    return (muleEventExprBuilder) -> {
      mUnitSetEventParser.parse(messageProcessorNode.getComponentModel(), muleEventExprBuilder);
    };
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return (boolean) messageProcessorNode.getComponentModel()
        .getParameter(DEFAULT_GROUP_NAME, ATTR_CLONE_ORIGINAL_EVENT).getValue().getRight();
  }

}
