package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.Set;

public class ThrowsErrorsTypeAnnotation implements AstNodeAnnotation {

  private final Set<ErrorModel> errorModelSet;

  public ThrowsErrorsTypeAnnotation(Set<ErrorModel> errorModelSet) {
    Preconditions.checkNotNull(errorModelSet);
    this.errorModelSet = errorModelSet;
  }

  public Set<ErrorModel> getErrors() {
    return errorModelSet;
  }
}
