package org.mule.datasense.impl.model.annotations.munit;

import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MuleFlowNode;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MUnitDeclarationsAnnotation implements AstNodeAnnotation {

  private final Map<String, MUnitDeclaration> mUnitDeclarations;

  public MUnitDeclarationsAnnotation() {
    mUnitDeclarations = new HashMap<>();
  }

  public Optional<MuleFlowNode> getBeforeTestMuleFlowNode(MuleFlowNode muleFlowNode) {
    return get(muleFlowNode).map(MUnitDeclaration::getBeforeTestMuleFlowNode);
  }

  public Optional<MuleFlowNode> getAfterTestMuleFlowNode(MuleFlowNode muleFlowNode) {
    return get(muleFlowNode).map(MUnitDeclaration::getAfterTestMuleFlowNode);
  }

  public Optional<MuleFlowNode> getBeforeSuiteMuleFlowNode(MuleFlowNode muleFlowNode) {
    return get(muleFlowNode).map(MUnitDeclaration::getBeforeSuiteMuleFlowNode);
  }

  public Optional<MuleFlowNode> getAfterSuiteMuleFlowNode(MuleFlowNode muleFlowNode) {
    return get(muleFlowNode).map(MUnitDeclaration::getAfterSuiteMuleFlowNode);
  }

  public void setBeforeTestMuleFlowNode(MuleFlowNode beforeTestMuleFlowNode) {
    final MUnitDeclaration mUnitDeclaration = getOrCreate(beforeTestMuleFlowNode);
    mUnitDeclaration.setBeforeTestMuleFlowNode(beforeTestMuleFlowNode);
  }

  public void setAfterTestMuleFlowNode(MuleFlowNode afterTestMuleFlowNode) {
    final MUnitDeclaration mUnitDeclaration = getOrCreate(afterTestMuleFlowNode);
    mUnitDeclaration.setAfterTestMuleFlowNode(afterTestMuleFlowNode);
  }

  public void setBeforeSuiteMuleFlowNode(MuleFlowNode beforeSuiteMuleFlowNode) {
    final MUnitDeclaration mUnitDeclaration = getOrCreate(beforeSuiteMuleFlowNode);
    mUnitDeclaration.setBeforeSuiteMuleFlowNode(beforeSuiteMuleFlowNode);
  }

  public void setAfterSuiteMuleFlowNode(MuleFlowNode afterSuiteMuleFlowNode) {
    final MUnitDeclaration mUnitDeclaration = getOrCreate(afterSuiteMuleFlowNode);
    mUnitDeclaration.setAfterSuiteMuleFlowNode(afterSuiteMuleFlowNode);
  }

  private String getKey(MuleFlowNode muleFlowNode) {
    return muleFlowNode.getComponentModel().getMetadata().getFileName()
        // return ((ComponentModel) muleFlowNode.getComponentModel()).getConfigFileName()
        .orElseThrow(() -> new IllegalArgumentException("Config file not set."));
  }

  private MUnitDeclaration getOrCreate(MuleFlowNode muleFlowNode) {
    final String key = getKey(muleFlowNode);
    MUnitDeclaration mUnitDeclaration = mUnitDeclarations.get(key);
    if (mUnitDeclaration == null) {
      mUnitDeclaration = new MUnitDeclaration();
      mUnitDeclarations.put(key, mUnitDeclaration);
    }
    return mUnitDeclaration;
  }

  private Optional<MUnitDeclaration> get(MuleFlowNode muleFlowNode) {
    final String key = getKey(muleFlowNode);
    return Optional.ofNullable(mUnitDeclarations.get(key));
  }
}
