package org.mule.datasense.impl.model.event;

public class LiteralValueExprBuilder implements ExprBuilder {

  private String value;
  private String mimeType;

  public LiteralValueExprBuilder(String value) {
    if (value == null) {
      value = "";
    }
    this.value = value;
    this.mimeType = null;
  }

  public LiteralValueExprBuilder mimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  @Override
  public Expr build() {
    return new LiteralValueExpr(value, mimeType);
  }
}
