package org.mule.datasense.impl.model.types;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultBinaryType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNothingType;
import org.mule.metadata.api.model.impl.DefaultNullType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultPeriodType;
import org.mule.metadata.api.model.impl.DefaultRegexType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.model.impl.DefaultVoidType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.xml.namespace.QName;

//import org.mule.metadata.message.DefaultMessageMetadataType;
//import org.mule.metadata.message.DefaultMuleEventMetadataType;

public class MetadataTypeTransform {

  public MetadataType transform(MetadataType metadataType) {
    if (metadataType instanceof DefaultAnyType) {
      return visitAnyType((DefaultAnyType) metadataType);
    } else if (metadataType instanceof DefaultArrayType) {
      return visitArrayType((DefaultArrayType) metadataType);
    } else if (metadataType instanceof DefaultBinaryType) {
      return transformBinaryType((DefaultBinaryType) metadataType);
    } else if (metadataType instanceof DefaultBooleanType) {
      return transformBoolean((DefaultBooleanType) metadataType);
    } else if (metadataType instanceof DefaultDateTimeType) {
      return visitDateTime((DefaultDateTimeType) metadataType);
    } else if (metadataType instanceof DefaultDateType) {
      return visitDate((DefaultDateType) metadataType);
    } else if (metadataType instanceof DefaultNullType) {
      return visitNull((DefaultNullType) metadataType);
    } else if (metadataType instanceof DefaultVoidType) {
      return visitVoid((DefaultVoidType) metadataType);
    } else if (metadataType instanceof DefaultNumberType) {
      return visitNumber((DefaultNumberType) metadataType);
    } else if (metadataType instanceof DefaultObjectType) {
      return visitObject((DefaultObjectType) metadataType);
    } else if (metadataType instanceof DefaultStringType) {
      return visitString((DefaultStringType) metadataType);
    } else if (metadataType instanceof DefaultTimeType) {
      return visitTime((DefaultTimeType) metadataType);
    } else if (metadataType instanceof DefaultTupleType) {
      return visitTuple((DefaultTupleType) metadataType);
    } else if (metadataType instanceof DefaultUnionType) {
      return visitUnion((DefaultUnionType) metadataType);
    } else if (metadataType instanceof DefaultIntersectionType) {
      return visitIntersection((DefaultIntersectionType) metadataType);
    } else if (metadataType instanceof DefaultObjectKeyType) {
      return visitObjectKey((DefaultObjectKeyType) metadataType);
    } else if (metadataType instanceof DefaultAttributeKeyType) {
      return visitAttributeKey((DefaultAttributeKeyType) metadataType);
    } else if (metadataType instanceof DefaultAttributeFieldType) {
      return visitAttributeField((DefaultAttributeFieldType) metadataType);
    } else if (metadataType instanceof DefaultObjectFieldType) {
      return visitObjectField((DefaultObjectFieldType) metadataType);
    } else if (metadataType instanceof DefaultNothingType) {
      return visitNothing((DefaultNothingType) metadataType);
    } else if (metadataType instanceof DefaultFunctionType) {
      return visitFunction((DefaultFunctionType) metadataType);
    } else if (metadataType instanceof DefaultLocalDateTimeType) {
      return visitLocalDateTime((DefaultLocalDateTimeType) metadataType);
    } else if (metadataType instanceof DefaultLocalTimeType) {
      return visitLocalTime((DefaultLocalTimeType) metadataType);
    } else if (metadataType instanceof DefaultPeriodType) {
      return visitPeriod((DefaultPeriodType) metadataType);
    } else if (metadataType instanceof DefaultRegexType) {
      return visitRegex((DefaultRegexType) metadataType);
    } else if (metadataType instanceof DefaultTimeZoneType) {
      return visitTimeZone((DefaultTimeZoneType) metadataType);
    } else if (metadataType instanceof DefaultTypeParameterType) {
      return visitTypeParameter((DefaultTypeParameterType) metadataType);
      /*
          } else if (metadataType instanceof DefaultMessageMetadataType) {
      return visitMessageMetadataType((DefaultMessageMetadataType) metadataType);
          } else if (metadataType instanceof DefaultMuleEventMetadataType) {
      return visitMuleEventMetadataType((DefaultMuleEventMetadataType) metadataType);
      */
    } else {
      throw new IllegalArgumentException();
    }
  }

  /*
  private MetadataType visitMuleEventMetadataType(DefaultMuleEventMetadataType metadataType) {
    final Supplier<MessageMetadataType> messageMetadataType =
        () -> (MessageMetadataType) transform(metadataType.getMessageType());
    final Supplier<ObjectType> variables = () -> (ObjectType) transform(metadataType.getVariables());
    return transformMuleEventMetadataType(messageMetadataType, variables, metadataType.getExtensions());
  }
  
  protected MetadataType transformMuleEventMetadataType(Supplier<MessageMetadataType> messageMetadataType,
                                                        Supplier<ObjectType> variables,
                                                        Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultMuleEventMetadataType(messageMetadataType.get(), variables.get(), extensions);
  }
  
  private MetadataType visitMessageMetadataType(DefaultMessageMetadataType metadataType) {
    final Supplier<Optional<MetadataType>> payloadMetadataType = () -> metadataType.getPayloadType().map(this::transform);
    final Supplier<Optional<MetadataType>> attributesMetadataType = () -> metadataType.getAttributesType().map(this::transform);
    return transformMessageMetadataType(payloadMetadataType, attributesMetadataType, metadataType.getExtensions());
  }
  
  protected MetadataType transformMessageMetadataType(Supplier<Optional<MetadataType>> payloadMetadataType,
                                                      Supplier<Optional<MetadataType>> attributesMetadataType,
                                                      Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultMessageMetadataType(payloadMetadataType.get(), attributesMetadataType.get(), extensions);
  }
  */

  private Map<Class<? extends TypeAnnotation>, TypeAnnotation> getExtensions(BaseMetadataType metadataType) {
    Map<Class<? extends TypeAnnotation>, TypeAnnotation> result = new HashMap<>();
    metadataType.getAnnotations().forEach(typeAnnotation -> {
      result.put(typeAnnotation.getClass(), typeAnnotation);
    });
    return result;
  }

  private MetadataType visitAnyType(DefaultAnyType anyType) {
    return transformAnyType(anyType.getMetadataFormat(), getExtensions(anyType));
  }

  protected MetadataType transformAnyType(MetadataFormat metadataFormat,
                                          Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultAnyType(metadataFormat, extensions);
  }

  private MetadataType visitArrayType(DefaultArrayType arrayType) {
    return transformArrayType(() -> transform(arrayType.getType()), arrayType.getMetadataFormat(), getExtensions(arrayType));
  }

  protected MetadataType transformArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultArrayType(type, metadataFormat, extensions);
  }

  private MetadataType transformBinaryType(DefaultBinaryType binaryType) {
    return transformBinaryType(binaryType.getMetadataFormat(), getExtensions(binaryType));
  }

  protected MetadataType transformBinaryType(MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultBinaryType(metadataFormat, extensions);
  }

  private MetadataType transformBoolean(DefaultBooleanType booleanType) {
    return transformBoolean(booleanType.getMetadataFormat(), getExtensions(booleanType));
  }

  protected MetadataType transformBoolean(MetadataFormat metadataFormat,
                                          Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultBooleanType(metadataFormat, extensions);
  }

  private MetadataType visitDateTime(DefaultDateTimeType dateTimeType) {
    return transformDateTime(dateTimeType.getMetadataFormat(), getExtensions(dateTimeType));
  }

  protected MetadataType transformDateTime(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultDateTimeType(metadataFormat, extensions);
  }

  private MetadataType visitDate(DefaultDateType dateType) {
    return transformDateType(dateType.getMetadataFormat(), getExtensions(dateType));
  }

  protected MetadataType transformDateType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultDateType(metadataFormat, extensions);
  }

  private MetadataType visitNull(DefaultNullType nullType) {
    return transformNullType(nullType.getMetadataFormat(), getExtensions(nullType));
  }

  protected MetadataType transformNullType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultNullType(metadataFormat, extensions);
  }

  private MetadataType visitVoid(DefaultVoidType voidType) {
    return transformVoidType(voidType.getMetadataFormat(), getExtensions(voidType));
  }

  protected MetadataType transformVoidType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultVoidType(metadataFormat, extensions);
  }

  private MetadataType visitNumber(DefaultNumberType numberType) {
    return transformNumberType(numberType.getMetadataFormat(), getExtensions(numberType));
  }

  protected MetadataType transformNumberType(MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultNumberType(metadataFormat, extensions);
  }

  private MetadataType visitObject(DefaultObjectType objectType) {
    final Supplier<List<ObjectFieldType>> fields = () -> objectType.getFields().stream()
        .map(objectFieldType -> (ObjectFieldType) transform(objectFieldType)).collect(Collectors.toList());
    return transformObjectType(fields, objectType.isOrdered(), objectType.getOpenRestriction().map(this::transform).orElse(null),
                               objectType.getMetadataFormat(), getExtensions(objectType));
  }

  protected MetadataType transformObjectType(Supplier<List<ObjectFieldType>> fields, boolean ordered,
                                             MetadataType openRestriction,
                                             MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultObjectType(fields.get(), ordered, openRestriction, metadataFormat, extensions);
  }

  private MetadataType visitString(DefaultStringType stringType) {
    return transformStringType(stringType.getMetadataFormat(), getExtensions(stringType));
  }

  protected MetadataType transformStringType(MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultStringType(metadataFormat, extensions);
  }

  private MetadataType visitTime(DefaultTimeType timeType) {
    return transformTimeType(timeType.getMetadataFormat(), getExtensions(timeType));
  }

  protected MetadataType transformTimeType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultTimeType(metadataFormat, extensions);
  }

  private MetadataType visitTuple(DefaultTupleType tupleType) {
    final Supplier<List<MetadataType>> types =
        () -> tupleType.getTypes().stream().map(this::transform).collect(Collectors.toList());
    return transformTupleType(types, tupleType.getMetadataFormat(), getExtensions(tupleType));
  }

  protected MetadataType transformTupleType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultTupleType(types.get(), metadataFormat, extensions);
  }

  private MetadataType visitUnion(DefaultUnionType unionType) {
    final Supplier<List<MetadataType>> types =
        () -> unionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
    return transformUnionType(types, unionType.getMetadataFormat(), getExtensions(unionType));
  }

  protected MetadataType transformUnionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultUnionType(types.get(), metadataFormat, extensions);
  }

  private MetadataType visitIntersection(DefaultIntersectionType intersectionType) {
    final Supplier<List<MetadataType>> types =
        () -> intersectionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
    return transformIntersectionType(types, intersectionType.getMetadataFormat(), getExtensions(intersectionType));
  }

  protected MetadataType transformIntersectionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultIntersectionType(types.get(), metadataFormat, extensions);
  }

  private MetadataType visitObjectKey(DefaultObjectKeyType objectKeyType) {
    final Supplier<List<AttributeFieldType>> attributes =
        () -> objectKeyType.getAttributes().stream().map(attributeFieldType -> (AttributeFieldType) transform(attributeFieldType))
            .collect(Collectors.toList());
    final Optional<QName> name = Optional.ofNullable(objectKeyType.isName() ? objectKeyType.getName() : null);
    final Optional<Pattern> pattern = Optional.ofNullable(objectKeyType.isPattern() ? objectKeyType.getPattern() : null);
    return transformObjectKeyType(name, pattern, attributes, objectKeyType.getMetadataFormat(), getExtensions(objectKeyType));
  }

  protected MetadataType transformObjectKeyType(Optional<QName> name, Optional<Pattern> pattern,
                                                Supplier<List<AttributeFieldType>> attributes,
                                                MetadataFormat metadataFormat,
                                                Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultObjectKeyType(name, pattern, attributes.get(), metadataFormat, extensions);
  }

  private MetadataType visitAttributeKey(DefaultAttributeKeyType attributeKeyType) {
    final Optional<QName> name = Optional.ofNullable(attributeKeyType.isName() ? attributeKeyType.getName() : null);
    final Optional<Pattern> pattern = Optional.ofNullable(attributeKeyType.isPattern() ? attributeKeyType.getPattern() : null);
    return transformAttributeKeyType(name, pattern, attributeKeyType.getMetadataFormat(), getExtensions(attributeKeyType));
  }

  protected MetadataType transformAttributeKeyType(Optional<QName> name, Optional<Pattern> pattern, MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultAttributeKeyType(name, pattern, metadataFormat, extensions);
  }

  private MetadataType visitAttributeField(DefaultAttributeFieldType attributeFieldType) {
    return transformAttributeFieldType(() -> (AttributeKeyType) transform(attributeFieldType.getKey()),
                                       () -> (SimpleType) transform(attributeFieldType.getValue()),
                                       attributeFieldType.isRequired(),
                                       attributeFieldType.getMetadataFormat(), getExtensions(attributeFieldType));
  }

  protected MetadataType transformAttributeFieldType(Supplier<AttributeKeyType> key, Supplier<SimpleType> value, boolean required,
                                                     MetadataFormat metadataFormat,
                                                     Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultAttributeFieldType(key.get(), value.get(), required, metadataFormat, extensions);
  }

  private MetadataType visitObjectField(DefaultObjectFieldType objectFieldType) {
    return transformDefaultObjectFieldType(() -> (ObjectKeyType) transform(objectFieldType.getKey()),
                                           () -> transform(objectFieldType.getValue()), objectFieldType.isRequired(),
                                           objectFieldType.isRepeated(),
                                           objectFieldType.getMetadataFormat(), getExtensions(objectFieldType));
  }

  protected MetadataType transformDefaultObjectFieldType(Supplier<ObjectKeyType> key, Supplier<MetadataType> value,
                                                         boolean required,
                                                         boolean repeated, MetadataFormat metadataFormat,
                                                         Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultObjectFieldType(key.get(), value.get(), required, repeated, metadataFormat, extensions);
  }

  private MetadataType visitNothing(DefaultNothingType nothingType) {
    return transformNothingType(nothingType.getMetadataFormat(), getExtensions(nothingType));
  }

  protected MetadataType transformNothingType(MetadataFormat metadataFormat,
                                              Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultNothingType(metadataFormat, extensions);
  }

  private MetadataType visitFunction(DefaultFunctionType functionType) {
    final Supplier<List<FunctionParameter>> functionParameters = () -> functionType.getParameters().stream()
        .map(functionParameter -> new FunctionParameter(functionParameter.getName(), transform(functionParameter.getType())))
        .collect(
                 Collectors.toList());
    final Supplier<Optional<MetadataType>> returnType = () -> functionType.getReturnType().map(this::transform);
    return transformFunctionType(functionType.getMetadataFormat(), getExtensions(functionType), returnType, functionParameters);
  }

  protected MetadataType transformFunctionType(MetadataFormat metadataFormat,
                                               Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions,
                                               Supplier<Optional<MetadataType>> returnType,
                                               Supplier<List<FunctionParameter>> functionParameters) {
    return new DefaultFunctionType(metadataFormat, extensions, returnType.get(), functionParameters.get());
  }

  private MetadataType visitLocalDateTime(DefaultLocalDateTimeType localDateTimeType) {
    return transformLocalDateTimeType(localDateTimeType.getMetadataFormat(), getExtensions(localDateTimeType));
  }

  protected MetadataType transformLocalDateTimeType(MetadataFormat metadataFormat,
                                                    Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultLocalDateTimeType(metadataFormat, extensions);
  }

  private MetadataType visitLocalTime(DefaultLocalTimeType localTimeType) {
    return transformLocalTimeType(localTimeType.getMetadataFormat(), getExtensions(localTimeType));
  }

  protected MetadataType transformLocalTimeType(MetadataFormat metadataFormat,
                                                Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultLocalTimeType(metadataFormat, extensions);
  }

  private MetadataType visitPeriod(DefaultPeriodType periodType) {
    return transformDefaultPeriodType(periodType.getMetadataFormat(), getExtensions(periodType));
  }

  protected MetadataType transformDefaultPeriodType(MetadataFormat metadataFormat,
                                                    Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultPeriodType(metadataFormat, extensions);
  }

  private MetadataType visitRegex(DefaultRegexType regexType) {
    return transformDefaultRegexType(regexType.getMetadataFormat(), getExtensions(regexType));
  }

  protected MetadataType transformDefaultRegexType(MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultRegexType(metadataFormat, extensions);
  }

  private MetadataType visitTimeZone(DefaultTimeZoneType timeZoneType) {
    return transformDefaultTimeZoneType(timeZoneType.getMetadataFormat(), getExtensions(timeZoneType));
  }

  protected MetadataType transformDefaultTimeZoneType(MetadataFormat metadataFormat,
                                                      Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultTimeZoneType(metadataFormat, extensions);
  }

  private MetadataType visitTypeParameter(DefaultTypeParameterType defaultTypeParameter) {
    return transformDefaultTypeParameterType(defaultTypeParameter.getName(), defaultTypeParameter.getMetadataFormat(),
                                             getExtensions(defaultTypeParameter));
  }

  protected MetadataType transformDefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultTypeParameterType(name, metadataFormat, extensions);
  }
}
