package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;

public class TypeResolverAnnotator extends BaseAnnotator {

  private final TypeResolverRegistry typeResolverRegistry;

  public TypeResolverAnnotator(TypeResolverRegistry typeResolverRegistry) {
    this.typeResolverRegistry = typeResolverRegistry;
  }

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    typeResolverRegistry.get(messageProcessorNode.getComponentIdentifier()).ifPresent(typeResolver -> {
      messageProcessorNode.annotate(new TypeResolverAnnotation(messageProcessorNode.getComponentIdentifier()));
    });
  }
}
