package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.ERROR_MAPPINGS;
import static org.mule.runtime.extension.api.ExtensionConstants.ERROR_MAPPINGS_PARAMETER_NAME;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.ast.api.ComponentParameterAst;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ErrorMappingUtils {

  public static Optional<ErrorMapping> createErrorMapping(org.mule.runtime.extension.api.error.ErrorMapping errorMapping) {
    return ErrorMapping.create(errorMapping.getSource(), errorMapping.getTarget());
  }

  public static Optional<ErrorMapper> createErrorMapper(MessageProcessorNode messageProcessorNode) {
    List<ErrorMapping> errorMappings = new ArrayList<>();
    Optional.ofNullable(messageProcessorNode.getComponentModel()).ifPresent(componentModel -> {
      final ComponentParameterAst errorMappingsAst = componentModel.getParameter(ERROR_MAPPINGS, ERROR_MAPPINGS_PARAMETER_NAME);
      if (errorMappingsAst == null) {
        return;
      }

      errorMappingsAst.getValue()
          .applyRight(ems -> ((Iterable<org.mule.runtime.extension.api.error.ErrorMapping>) ems).forEach(childComponentModel -> {
            ErrorMappingUtils.createErrorMapping(childComponentModel).ifPresent(errorMappings::add);
          }));
    });
    return Optional.ofNullable(errorMappings.isEmpty() ? null : new ErrorMapper(errorMappings));
  }
}
