package org.mule.datasense.impl.phases.typing.resolver.munit;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ScopeTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;

import java.util.Optional;

public class MUnitTestTypeResolver extends ScopeTypeResolver {

  public MUnitTestTypeResolver(ComponentIdentifier componentIdentiferScopeIn,
                               ComponentIdentifier componentIdentiferScopeOut) {
    super(componentIdentiferScopeIn, componentIdentiferScopeOut);
  }

  private static Optional<MuleFlowNode> getBeforeTestMuleFlowNode(MuleApplicationNode muleApplicationNode,
                                                                  MuleFlowNode muleFlowNode) {
    return muleApplicationNode.getAnnotation(MUnitDeclarationsAnnotation.class).flatMap(mUnitDeclarationsAnnotation -> {
      return mUnitDeclarationsAnnotation.getBeforeTestMuleFlowNode(muleFlowNode);
    });
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
    typingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> {
      final MuleFlowNode muleFlowNode = muleFlowAnnotation.getMuleFlowNode();
      typingMuleAstVisitorContext.getAnnotation(MuleApplicationAnnotation.class).ifPresent(muleApplicationAnnotation -> {
        muleApplicationAnnotation.getMuleApplicationNode().getAnnotation(MUnitDeclarationsAnnotation.class)
            .ifPresent(mUnitDeclarationsAnnotation -> {
              final Optional<MuleFlowNode> beforeTestMuleFlowNode =
                  mUnitDeclarationsAnnotation.getBeforeTestMuleFlowNode(muleFlowNode);
              System.out.println(beforeTestMuleFlowNode);
            });
      });
    });

    return super.resolve(messageProcessorNode, inputEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }


  public static class ScopeIn extends ScopeTypeResolver.ScopeIn {

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                                TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
      inputEventType = visitorContext.getAnnotation(MuleFlowAnnotation.class).flatMap(muleFlowAnnotation -> {
        final MuleFlowNode muleFlowNode = muleFlowAnnotation.getMuleFlowNode();
        return visitorContext.getAnnotation(MuleApplicationAnnotation.class).flatMap(muleApplicationAnnotation -> {
          final MuleApplicationNode muleApplicationNode = muleApplicationAnnotation.getMuleApplicationNode();

          return getBeforeTestMuleFlowNode(muleApplicationNode, muleFlowNode).flatMap(beforeTestMuleFlowNode -> {
            Optional<DefinesTypeAnnotation> definesTypeAnnotation =
                beforeTestMuleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
            if (!definesTypeAnnotation.isPresent()) {
              // attempt from inference
              typingMuleAstVisitor.resolveType(beforeTestMuleFlowNode, TypeUtils.createEventType(null),
                                               visitorContext.getAstNotification(), muleApplicationNode);
              definesTypeAnnotation = beforeTestMuleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
            }
            return definesTypeAnnotation;
          });
        });
      }).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());

      messageProcessorNode.annotate(new DefinesTypeAnnotation(inputEventType));

      return inputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
      return true;
    }
  }

}
