package org.mule.datasense.impl.tooling;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.util.bindings.TypeBindingUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;

/**
 *
 */
public class TypeInfoQuery implements TypedApplicationQuery<TypeInfoQueryResult> {

  private final Location location;

  public TypeInfoQuery(
                       Location location) {
    this.location = location;
  }

  // input/output mulevent types

  /**
   * @param muleApplicationNode
   * @param dataSenseProviderResolver
   * @param astNotification
   * @return
   */
  @Override
  public Optional<TypeInfoQueryResult> perform(MuleApplicationNode muleApplicationNode,
                                               DataSenseProviderResolver dataSenseProviderResolver,
                                               AstNotification astNotification) {
    return muleApplicationNode
        .findMessageProcessorNode(location)
        .map(messageProcessorNode -> new TypeInfoQueryResult(
                                                             TypeUtils.asMuleEventMetadataType(messageProcessorNode
                                                                 .getAnnotation(UsesTypeAnnotation.class).map(
                                                                                                              UsesTypeAnnotation::getUsesEventType)
                                                                 .orElse(new EventType())).build(),
                                                             TypeUtils.asMuleEventMetadataType(messageProcessorNode
                                                                 .getAnnotation(DefinesTypeAnnotation.class).map(
                                                                                                                 DefinesTypeAnnotation::getDefinesEventType)
                                                                 .orElse(new EventType())).build()));
  }

  public static Map<String, MetadataType> getGlobalTypeBindings(MuleApplicationNode muleApplicationNode) {
    return muleApplicationNode.getAnnotation(GlobalBindingsAnnotation.class).map(GlobalBindingsAnnotation::getTypeBindings)
        .map(typeBindings -> TypeBindingUtils
            .toMap(typeBindings))
        .orElse(Collections.emptyMap());
  }

  public static Map<String, MetadataType> getFunctionBindings(MuleApplicationNode muleApplicationNode) {
    return muleApplicationNode.getAnnotation(FunctionBindingsAnnotation.class)
        .map(FunctionBindingsAnnotation::getFunctionBindings).map(typeBindings -> TypeBindingUtils
            .toMap(typeBindings))
        .orElse(Collections.emptyMap());
  }

}
