package org.mule.datasense.impl.util.extension;

import static java.util.Optional.ofNullable;
import static org.mule.runtime.api.functional.Either.right;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.OUTPUT;

import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ExtensionUtils {

  public static final String PARAMETER_TARGET = "target";
  public static final String PARAMETER_TARGET_VALUE = "targetValue";
  public static final String PARAMETER_OUTPUT_MIME_TYPE = "outputMimeType";
  public static final String PARAMETER_MIME_TYPE = "mimeType";

  private static List<String> RESERVED_PARAMETERS = Arrays.asList(PARAMETER_TARGET, PARAMETER_TARGET_VALUE);

  public static boolean isOutputParameter(String parameter) {
    return RESERVED_PARAMETERS.contains(parameter);
  }

  public static Either<String, String> findParameter(ComponentAst componentModel, String groupName, String parameter) {
    final ComponentParameterAst param = componentModel.getParameter(groupName, parameter);
    if (param != null) {
      return param.getValue();
    } else {
      return right(null);
    }
  }

  public static Optional<String> findTarget(ComponentAst componentModel) {
    return ofNullable(findParameter(componentModel, OUTPUT, ExtensionUtils.PARAMETER_TARGET).getRight());
  }

  public static Optional<String> findOutputMimeType(ComponentAst componentModel) {
    return ofNullable(findParameter(componentModel, DEFAULT_GROUP_NAME, ExtensionUtils.PARAMETER_OUTPUT_MIME_TYPE).getRight());
  }

  public static Optional<String> findMimeType(ComponentAst componentModel) {
    return ofNullable(findParameter(componentModel, DEFAULT_GROUP_NAME, ExtensionUtils.PARAMETER_MIME_TYPE).getRight());
  }

  public static Optional<String> findTargetValue(ComponentAst componentModel) {
    return ofNullable(findParameter(componentModel, OUTPUT, ExtensionUtils.PARAMETER_TARGET_VALUE).getLeft());
  }
}
