/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.BaseDynamicAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public class DynamicSourceAnnotator
extends BaseDynamicAnnotator<SourceModel> {
    @Override
    protected MetadataResult<SourceModel> resolveMetadata(MessageProcessorNode messageProcessorNode, DataSenseMetadataProvider dataSenseMetadataProvider, ComponentLocationAnnotation componentLocationAnnotation, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        MetadataResult<SourceModel> sourceMetadata = dataSenseMetadataProvider.getSourceMetadata(messageProcessorNode.getComponentModel());
        if (sourceMetadata != null) {
            if (sourceMetadata.isSuccess()) {
                SourceModel sourceModel = (SourceModel)sourceMetadata.get();
                messageProcessorNode.annotate(new SourceModelAnnotation(sourceModel));
            }
        } else {
            annotatingMuleAstVisitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Failed to obtain dynamic metadata resolving request [%s].", (Object[])new Object[]{"source metadata for component_path: " + componentLocationAnnotation.getLocation()}));
        }
        return sourceMetadata;
    }
}

