/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Collections;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleEventExprAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.transform.TransformParser;
import org.mule.metadata.message.api.MuleEventMetadataType;

public class TransformTypeResolver
extends SingleNodeTypeResolver {
    private final TransformParser transformParser = new TransformParser();

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        MuleEventExpr muleEventExpr = messageProcessorNode.getAnnotation(MuleEventExprAnnotation.class).map(MuleEventExprAnnotation::getMuleEventExpr).orElse(new MuleEventExpr(Collections.EMPTY_LIST));
        ResolveTypeContext resolveTypeContext = new ResolveTypeContext(visitorContext.getExpressionLanguageMetadataService(), this.createMessageCallbackFactory(visitorContext.getAstNotification(), messageProcessorNode.getAstNodeLocation()), visitorContext.getTypeBindings());
        MuleEventMetadataType muleEventMetadataType = muleEventExpr.resolveType(TypeUtils.asMuleEventMetadataType(inputEventType).build(), resolveTypeContext);
        EventType outputEventType = TypeUtils.asEventType(muleEventMetadataType);
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

