/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDeclMetadata;
import org.mule.metadata.api.model.MetadataType;

public class VarDecl {
    private final String name;
    private final MetadataType metadataType;
    private final VarDeclMetadata varDeclMetadata;
    private final boolean optional;

    public VarDecl(String name, MetadataType metadataType) {
        this(name, metadataType, false, null);
    }

    public VarDecl(String name, MetadataType metadataType, boolean optional) {
        this(name, metadataType, optional, null);
    }

    public VarDecl(String name, MetadataType metadataType, VarDeclMetadata varDeclMetadata) {
        this(name, metadataType, false, varDeclMetadata);
    }

    public VarDecl(String name, MetadataType metadataType, boolean optional, VarDeclMetadata varDeclMetadata) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)metadataType);
        this.optional = optional;
        this.name = name;
        this.metadataType = metadataType;
        this.varDeclMetadata = varDeclMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarDecl varDecl = (VarDecl)o;
        return this.name.equals(varDecl.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public MetadataType getType() {
        return this.metadataType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Optional<VarDeclMetadata> getMetadata() {
        return Optional.ofNullable(this.varDeclMetadata);
    }

    public String toString() {
        return "VarDecl{name='" + this.name + '\'' + ", metadataType=" + TypesHelper.toString(this.metadataType) + '}';
    }
}

