/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleAstParser {
    public static final String MULE_CORE = "http://www.mulesoft.org/schema/mule/core";
    public static final String MULE_CORE_PREFIX = "mule";
    public static final String MULE_EE_CORE = "http://www.mulesoft.org/schema/mule/ee/core";
    public static final String MULE_EE_CORE_PREFIX = "ee";
    public static final String MULE_TRACING_PREFIX = "tracing";
    public static final String MULE_TRACING = "http://www.mulesoft.org/schema/mule/tracing";
    public static final String MULE_EE_BATCH = "http://www.mulesoft.org/schema/mule/batch";
    public static final String MULE_EE_BATCH_PREFIX = "batch";
    public static final String MULE_MUNIT = "http://www.mulesoft.org/schema/mule/munit";
    public static final String MULE_MUNIT_PREFIX = "munit";
    public static final String MULE_AGGREGATORS = "http://www.mulesoft.org/schema/mule/aggregators";
    public static final String MULE_AGGREGATORS_PREFIX = "aggregators";
    public static final String MULE_HTTP_POLICY = "http://www.mulesoft.org/schema/mule/http-policy";
    public static final String MULE_HTTP_POLICY_PREFIX = "http-policy";
    private static Set<ComponentIdentifier> FLOW_COMPONENT_IDENTIFIERS = Stream.of(DefaultDataSense.COMPONENT_IDENTIFIER_FLOW, DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE, DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER, DefaultDataSense.COMPONENT_IDENTIFIER_MULE_HTTP_POLICY_PROXY).collect(Collectors.toSet());

    public Optional<AstNodeBuilder> parse(ComponentAst componentModel, MuleAstParserContext muleAstParserContext) {
        muleAstParserContext.enter(componentModel);
        Optional<Object> result = Optional.empty();
        ComponentIdentifier componentIdentifier = componentModel.getIdentifier();
        if (FLOW_COMPONENT_IDENTIFIERS.contains(componentIdentifier) && componentModel.getComponentId().isPresent()) {
            MuleFlowNodeBuilder muleFlowNodeBuilder = new MuleFlowNodeBuilder(componentModel.getIdentifier());
            muleFlowNodeBuilder.config(componentModel);
            boolean traverse = muleAstParserContext.getDataSenseResolutionScopeStrategy().map(dataSenseResolutionScopeStrategy -> dataSenseResolutionScopeStrategy.match(componentModel)).orElse(true);
            if (traverse) {
                ComponentIdentifier customizedComponentIdentifier = componentIdentifier;
                if (DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER.equals(componentIdentifier)) {
                    customizedComponentIdentifier = DefaultDataSense.COMPONENT_IDENTIFIER_GLOBAL_ERROR_HANDLER;
                }
                this.getAstNodeBuilder(componentModel, muleAstParserContext, customizedComponentIdentifier).ifPresent(astNodeBuilder -> {
                    if (astNodeBuilder instanceof MessageProcessorNodeBuilder) {
                        MessageProcessorNodeBuilder messageProcessorNodeBuilder = (MessageProcessorNodeBuilder)astNodeBuilder;
                        muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
                    }
                });
            }
            result = Optional.of(muleFlowNodeBuilder);
        } else {
            result = this.getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier);
        }
        if (!result.isPresent()) {
            muleAstParserContext.astlogger().debug("Ignoring unknown element " + componentIdentifier, new Object[0]);
        }
        muleAstParserContext.exit(componentModel);
        return result;
    }

    private Optional<AstNodeBuilder> getAstNodeBuilder(ComponentAst componentModel, MuleAstParserContext muleAstParserContext, ComponentIdentifier componentIdentifier) {
        Optional<AstNodeBuilder> result = muleAstParserContext.getComponentModelType(componentModel).map(componentModelType -> {
            Stream<MessageProcessorNodeBuilder> messageProcessorNodeBuilders = componentModel.directChildrenStream().map(innerComponentModel -> this.parse((ComponentAst)innerComponentModel, muleAstParserContext)).filter(Optional::isPresent).map(Optional::get).filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder).map(astNodeBuilder -> (MessageProcessorNodeBuilder)astNodeBuilder);
            MuleAstParseProvider parseProvider = muleAstParserContext.getParseProvider(componentModel).orElse(null);
            if (parseProvider != null) {
                return parseProvider.parse(componentIdentifier, componentModel, (ComponentModelType)((Object)componentModelType), messageProcessorNodeBuilders.collect(Collectors.toList()), muleAstParserContext).orElse(null);
            }
            MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
            messageProcessorNodeBuilder.config(componentModel);
            messageProcessorNodeBuilder.componentModelType((ComponentModelType)((Object)componentModelType));
            messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
            return messageProcessorNodeBuilder;
        });
        return result;
    }
}

