/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.ExpectedEventAnnotation;
import org.mule.datasense.impl.model.annotations.IncomingEventAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.DisplayMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;

public class DisplayMuleAstVisitor
implements AstNodeVisitor<DisplayMuleAstVisitorContext> {
    @Override
    public Object visit(MuleApplicationNode muleApplicationNode, DisplayMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleApplicationNode.getName());
        muleApplicationNode.getMuleFlowNodes().forEach(muleFlowNode -> muleFlowNode.accept(this, visitorContext));
        visitorContext.logger().exit(muleApplicationNode.getName());
        return null;
    }

    @Override
    public Object visit(MuleFlowNode muleFlowNode, DisplayMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(muleFlowNode.getName());
        muleFlowNode.getRootMessageProcessorNode().ifPresent(messageProcessorNode -> messageProcessorNode.accept(this, visitorContext));
        visitorContext.logger().exit(muleFlowNode.getName());
        return null;
    }

    @Override
    public Object visit(MessageProcessorNode messageProcessorNode, DisplayMuleAstVisitorContext visitorContext) {
        visitorContext.logger().enter(messageProcessorNode.getComponentIdentifier().toString());
        messageProcessorNode.getAnnotation(ComponentLocationAnnotation.class).ifPresent(componentPathAnnotation -> visitorContext.logger().debug("component_path: " + componentPathAnnotation.getLocation(), new Object[0]));
        messageProcessorNode.getAnnotation(UsesTypeAnnotation.class).ifPresent(annotation -> visitorContext.logger().debug("uses: " + TypesHelper.toString((MetadataType)TypeUtils.asMuleEventMetadataType(annotation.getUsesEventType()).build()), new Object[0]));
        messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).ifPresent(annotation -> visitorContext.logger().debug("defines: " + TypesHelper.toString((MetadataType)TypeUtils.asMuleEventMetadataType(annotation.getDefinesEventType()).build()), new Object[0]));
        messageProcessorNode.getAnnotation(IncomingEventAnnotation.class).ifPresent(annotation -> visitorContext.logger().debug("incoming: " + TypesHelper.toString((MetadataType)TypeUtils.asMuleEventMetadataType(annotation.getEventType()).build()), new Object[0]));
        messageProcessorNode.getAnnotation(ExpectedEventAnnotation.class).ifPresent(annotation -> visitorContext.logger().debug("expected: " + TypesHelper.toString((MetadataType)TypeUtils.asMuleEventMetadataType(annotation.getEventType()).build()), new Object[0]));
        messageProcessorNode.getMessageProcessorNodes().forEach(innerMessageProcessorNode -> innerMessageProcessorNode.accept(this, visitorContext));
        visitorContext.logger().exit(messageProcessorNode.getComponentIdentifier().toString());
        return null;
    }
}

