/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.introspection;

import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.introspection.DataQualifier;
import org.mule.extension.introspection.DataType;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.declaration.Declaration;

public class DataTypeTestCase {
    @Test
    public void simpleType() {
        DataType type = DataType.of(String.class);
        Assert.assertEquals(String.class, (Object)type.getRawType());
        this.assertNoGenericTypes(type);
        Assert.assertThat((Object)type.getQualifier(), (Matcher)Matchers.is((Object)DataQualifier.STRING));
    }

    @Test
    public void typeWithGeneric() {
        DataType type = DataType.of(Map.class, (Class[])new Class[]{String.class, Extension.class});
        this.assertMap(type, String.class, DataQualifier.STRING, Extension.class, DataQualifier.POJO);
        this.assertNoGenericTypes(type.getGenericTypes()[0]);
        this.assertNoGenericTypes(type.getGenericTypes()[1]);
    }

    @Test
    public void complexTypeWithManyGenerics() {
        DataType introspectionMap = DataType.of(Map.class, (Class[])new Class[]{Extension.class, Parameter.class});
        DataType declarationList = DataType.of(List.class, (Class[])new Class[]{Declaration.class});
        DataType type = DataType.of(Map.class, (DataType[])new DataType[]{introspectionMap, declarationList});
        this.assertMap(type, Map.class, DataQualifier.MAP, List.class, DataQualifier.LIST);
        this.assertMap(type.getGenericTypes()[0], Extension.class, DataQualifier.POJO, Parameter.class, DataQualifier.POJO);
        this.assertNoGenericTypes(type.getGenericTypes()[0].getGenericTypes()[0]);
        this.assertNoGenericTypes(type.getGenericTypes()[0].getGenericTypes()[1]);
        this.assertList(type.getGenericTypes()[1], Declaration.class, DataQualifier.POJO);
        this.assertNoGenericTypes(type.getGenericTypes()[1].getGenericTypes()[0]);
    }

    @Test
    public void equalsOfNoGenericType() {
        DataType type1 = DataType.of(String.class);
        DataType type2 = DataType.of(String.class);
        Assert.assertThat((Object)type1, (Matcher)Matchers.equalTo((Object)type2));
    }

    @Test
    public void equalsWithGenericType() {
        DataType type1 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        DataType type2 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        Assert.assertThat((Object)type1, (Matcher)Matchers.equalTo((Object)type2));
    }

    @Test
    public void notEqualsWithoutGenericTypes() {
        DataType type1 = DataType.of(Extension.class);
        DataType type2 = DataType.of(String.class);
        Assert.assertThat((Object)type1, (Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)type2)));
    }

    @Test
    public void notEqualsWithGenericTypes() {
        DataType type1 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        DataType type2 = DataType.of(Map.class, (Class[])new Class[]{String.class, Extension.class});
        Assert.assertThat((Object)type1, (Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)type2)));
    }

    @Test
    public void hashCodeOnEqualTypes() {
        DataType type1 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        DataType type2 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        Assert.assertThat((Object)type1.hashCode(), (Matcher)Matchers.equalTo((Object)type2.hashCode()));
    }

    @Test
    public void hashCodeOnUnequalTypes() {
        DataType type1 = DataType.of(Map.class, (Class[])new Class[]{String.class, Long.class});
        DataType type2 = DataType.of(Map.class, (Class[])new Class[]{String.class, Extension.class});
        Assert.assertThat((Object)type1.hashCode(), (Matcher)IsNot.not((Matcher)Matchers.equalTo((Object)type2.hashCode())));
    }

    private void assertList(DataType type, Class<?> valueType, DataQualifier valueQualifierType) {
        Assert.assertEquals(List.class, (Object)type.getRawType());
        Assert.assertThat((Object)type.getGenericTypes().length, (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)type.getQualifier(), (Matcher)Matchers.is((Object)DataQualifier.LIST));
        Assert.assertEquals(valueType, (Object)type.getGenericTypes()[0].getRawType());
        Assert.assertThat((Object)type.getGenericTypes()[0].getQualifier(), (Matcher)Matchers.is((Object)valueQualifierType));
    }

    private void assertMap(DataType type, Class<?> keyType, DataQualifier keyQualifier, Class<?> valueType, DataQualifier valueQualifier) {
        Assert.assertEquals(Map.class, (Object)type.getRawType());
        Assert.assertThat((Object)type.getGenericTypes().length, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)type.getQualifier(), (Matcher)Matchers.is((Object)DataQualifier.MAP));
        Assert.assertEquals(keyType, (Object)type.getGenericTypes()[0].getRawType());
        Assert.assertThat((Object)type.getGenericTypes()[0].getQualifier(), (Matcher)Matchers.is((Object)keyQualifier));
        Assert.assertEquals(valueType, (Object)type.getGenericTypes()[1].getRawType());
        Assert.assertThat((Object)type.getGenericTypes()[1].getQualifier(), (Matcher)Matchers.is((Object)valueQualifier));
    }

    private void assertNoGenericTypes(DataType type) {
        Assert.assertThat((Object)type.getGenericTypes(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)type.getGenericTypes().length, (Matcher)Matchers.is((Object)0));
    }
}

