/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.api.instrument.builder;

import org.mule.metrics.api.instrument.LongGauge;

import java.util.function.Supplier;

/**
 * The {@code LongGaugeBuilder} interface is used to construct instances of {@link LongGauge}. This interface extends
 * {@link InstrumentBuilder} with a generic type of {@code LongGauge}. It provides a method to supply the value of the gauge using
 * a {@link Supplier}.
 */
public interface LongGaugeBuilder extends InstrumentBuilder<LongGauge> {

  /**
   * Specifies the supplier that provides the current value of the gauge.
   *
   * @param valueSupplier a {@link Supplier} of {@code Long} that supplies the value for the gauge.
   * @return the current instance of {@code LongGaugeBuilder} for method chaining.
   */
  LongGaugeBuilder withValueSupplier(Supplier<Long> valueSupplier);
}
