/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.LinkedList;
import java.util.Queue;
import junit.framework.Assert;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.Payload;
import org.mule.transport.NullPayload;

@Module(name="munit", schemaVersion="1.0")
public class AssertModule {
    private Queue<Object> expectedPayload = new LinkedList<Object>();

    private static String wrapMessage(String message) {
        return message == null ? "" : message;
    }

    @Processor
    public void assertThat(@Optional String message, Object payloadIs, @Payload Object payload) {
        Assert.assertEquals((String)AssertModule.wrapMessage(message), (Object)payloadIs, (Object)payload);
    }

    @Processor
    public void assertTrue(@Optional String message, Boolean condition) {
        Assert.assertTrue((String)AssertModule.wrapMessage(message), (boolean)condition);
    }

    @Processor
    public void assertOnEquals(@Optional String message, @Optional Object expected, Object value) {
        if (expected == null) {
            expected = this.expectedPayload.poll();
        }
        Assert.assertEquals((String)AssertModule.wrapMessage(message), (Object)expected, (Object)value);
    }

    @Processor
    public void assertNotSame(@Optional String message, @Optional Object expected, Object value) {
        if (expected == null) {
            expected = this.expectedPayload.peek();
        }
        Assert.assertNotSame((String)AssertModule.wrapMessage(message), (Object)expected, (Object)value);
    }

    @Processor
    public void assertFalse(@Optional String message, Boolean condition) {
        Assert.assertFalse((String)AssertModule.wrapMessage(message), (boolean)condition);
    }

    @Processor
    public void assertNotNull(@Optional String message, @Payload Object payload) {
        Assert.assertFalse((String)AssertModule.wrapMessage(message), (boolean)(payload instanceof NullPayload));
    }

    @Processor
    public void assertNull(@Optional String message, @Payload Object payload) {
        Assert.assertTrue((String)AssertModule.wrapMessage(message), (boolean)(payload instanceof NullPayload));
    }

    @Processor
    public Object set(Object payload) {
        return payload;
    }

    @Processor
    public NullPayload setNullPayload() {
        return NullPayload.getInstance();
    }

    @Processor
    public void fail(@Optional String message) {
        Assert.fail((String)AssertModule.wrapMessage(message));
    }

    @Processor
    public void addExpected(Object value) {
        this.expectedPayload.add(value);
    }

    @Processor
    public void resetCalls() {
        this.expectedPayload = new LinkedList<Object>();
    }

    @Processor
    public void validateCalls() {
        Assert.assertTrue((boolean)this.expectedPayload.isEmpty());
    }
}

