/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.resource.spi.work.WorkListener;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.munit.config.MunitAfterSuite;
import org.mule.munit.config.MunitAfterTest;
import org.mule.munit.config.MunitBeforeSuite;
import org.mule.munit.config.MunitBeforeTest;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.config.MunitTest;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.TestingWorkListener;
import org.mule.util.ClassUtils;

public class MuleSuiteRunner
extends Runner
implements Filterable,
Sortable {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.org.mule.munit.config.AnnotationsConfigurationBuilder";
    private TestSuite testSuite;
    private MuleContext muleContext;
    private String resources;

    public MuleSuiteRunner(Class testClass) {
        try {
            Method getConfigResources = testClass.getMethod("getConfigResources", new Class[0]);
            this.resources = (String)getConfigResources.invoke(testClass.newInstance(), new Object[0]);
            this.muleContext = this.createMuleContext();
            this.muleContext.start();
            this.testSuite = new TestSuite();
            List<MunitFlow> before = this.lookupFlows(MunitBeforeTest.class);
            List<MunitFlow> after = this.lookupFlows(MunitAfterTest.class);
            List<MunitFlow> flowConstructs = this.lookupFlows(MunitTest.class);
            for (MunitFlow flowConstruct : flowConstructs) {
                this.testSuite.addTest((Test)new MuleTest(before, flowConstruct, after));
            }
        }
        catch (Exception e) {
            this.killMule();
            throw new RuntimeException(e);
        }
    }

    private List<MunitFlow> lookupFlows(Class munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }

    private void process(Collection<MunitFlow> flowConstructs, MuleEvent event) throws MuleException {
        for (MunitFlow flowConstruct : flowConstructs) {
            System.out.printf("%n" + flowConstruct.getDescription() + "%n", new Object[0]);
            flowConstruct.process(event);
        }
    }

    public Description getDescription() {
        return MuleSuiteRunner.makeDescription((Test)this.testSuite);
    }

    public TestListener createAdaptingListener(RunNotifier notifier) {
        return new OldTestClassAdaptingListener(notifier);
    }

    public void run(RunNotifier notifier) {
        TestResult result = new TestResult();
        result.addListener(this.createAdaptingListener(notifier));
        try {
            this.process(this.lookupFlows(MunitBeforeSuite.class), this.muleEvent());
            this.testSuite.run(result);
            this.process(this.lookupFlows(MunitAfterSuite.class), this.muleEvent());
            this.killMule();
        }
        catch (Exception e) {
            this.killMule();
            throw new RuntimeException("Could not Run the suite", e);
        }
    }

    private void killMule() {
        try {
            if (this.muleContext != null) {
                this.muleContext.stop();
            }
        }
        catch (MuleException muleException) {
            // empty catch block
        }
        if (this.muleContext != null) {
            this.muleContext.dispose();
        }
    }

    private static Description makeDescription(Test test) {
        if (test instanceof TestSuite) {
            TestSuite ts = (TestSuite)test;
            String name = ts.getName() == null ? MuleSuiteRunner.createSuiteDescription(ts) : ts.getName();
            Description description = Description.createSuiteDescription((String)name, (Annotation[])new Annotation[0]);
            int n = ts.testCount();
            for (int i = 0; i < n; ++i) {
                Description made = MuleSuiteRunner.makeDescription(ts.testAt(i));
                description.addChild(made);
            }
            return description;
        }
        MuleTest mt = (MuleTest)test;
        return Description.createTestDescription(((Object)((Object)mt)).getClass(), (String)mt.getName());
    }

    private static String createSuiteDescription(TestSuite ts) {
        int count = ts.countTestCases();
        String example = count == 0 ? "" : String.format(" [example: %s]", ts.testAt(0));
        return String.format("TestSuite with %s tests%s", count, example);
    }

    protected MuleContext createMuleContext() throws Exception {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builders = new ArrayList<Object>();
        builders.add(new SimpleConfigurationBuilder(null));
        if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, ((Object)((Object)this)).getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, ((Object)((Object)this)).getClass()));
        }
        builders.add(this.getBuilder());
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContext((MuleContextBuilder)contextBuilder);
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        return context;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        TestSuite filtered = new TestSuite(this.testSuite.getName());
        int n = this.testSuite.testCount();
        for (int i = 0; i < n; ++i) {
            Test test = this.testSuite.testAt(i);
            if (!filter.shouldRun(MuleSuiteRunner.makeDescription(test))) continue;
            filtered.addTest(test);
        }
        this.testSuite = filtered;
    }

    public void sort(Sorter sorter) {
        if (this.testSuite instanceof Sortable) {
            Sortable adapter = (Sortable)this.testSuite;
            adapter.sort(sorter);
        }
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(this.resources);
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    private MuleEvent muleEvent() {
        try {
            return MuleTestUtils.getTestEvent(null, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            return null;
        }
    }

    public class MuleTest
    extends TestCase {
        private List<MunitFlow> before;
        MunitFlow flow;
        private List<MunitFlow> after;

        public MuleTest(List<MunitFlow> before, MunitFlow flow, List<MunitFlow> after) {
            this.before = before;
            this.flow = flow;
            this.after = after;
        }

        public String getName() {
            return this.flow.getName();
        }

        public int countTestCases() {
            return 1;
        }

        protected void runTest() throws Throwable {
            MuleEvent event = MuleSuiteRunner.this.muleEvent();
            this.run(event, this.before);
            this.showDescription();
            try {
                this.flow.process(event);
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                this.run(event, this.after);
            }
        }

        private void run(MuleEvent event, List<MunitFlow> flows) throws MuleException {
            if (flows != null) {
                for (MunitFlow flow : flows) {
                    System.out.printf(flow.getDescription() + "%n", new Object[0]);
                    flow.process(event);
                }
            }
        }

        private void showDescription() {
            System.out.printf("%nDescription:%n************%n" + this.flow.getDescription().replaceAll("\\.", "\\.%n") + "%n", new Object[0]);
        }
    }

    private final class OldTestClassAdaptingListener
    implements TestListener {
        private final RunNotifier fNotifier;

        private OldTestClassAdaptingListener(RunNotifier notifier) {
            this.fNotifier = notifier;
        }

        public void endTest(Test test) {
            this.fNotifier.fireTestFinished(this.asDescription(test));
        }

        public void startTest(Test test) {
            this.fNotifier.fireTestStarted(this.asDescription(test));
        }

        public void addError(Test test, Throwable t) {
            Failure failure = new Failure(this.asDescription(test), t);
            this.fNotifier.fireTestFailure(failure);
        }

        private Description asDescription(Test test) {
            if (test instanceof Describable) {
                Describable facade = (Describable)test;
                return facade.getDescription();
            }
            return Description.createTestDescription(this.getEffectiveClass(test), (String)this.getName(test));
        }

        private Class<? extends Test> getEffectiveClass(Test test) {
            return test.getClass();
        }

        private String getName(Test test) {
            if (test instanceof TestCase) {
                return ((TestCase)test).getName();
            }
            return test.toString();
        }

        public void addFailure(Test test, AssertionFailedError t) {
            this.addError(test, (Throwable)t);
        }
    }
}

