/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.munit.config.AssertModuleLifecycleAdapter;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertThatMessageProcessor
implements FlowConstructAware,
MuleContextAware,
Disposable,
Initialisable,
Startable,
Stoppable,
MessageProcessor {
    private Object message;
    private String _messageType;
    private Object payloadIs;
    private Object _payloadIsType;
    private Object payload;
    private Object _payloadType;
    private static Logger logger = LoggerFactory.getLogger(AssertThatMessageProcessor.class);
    private Object moduleObject;
    private MuleContext muleContext;
    private ExpressionManager expressionManager;
    private TemplateParser.PatternInfo patternInfo;
    private FlowConstruct flowConstruct;
    private AtomicInteger retryCount;
    private int retryMax;

    public void initialise() throws InitialisationException {
        this.retryCount = new AtomicInteger();
        this.expressionManager = this.muleContext.getExpressionManager();
        this.patternInfo = TemplateParser.createMuleStyleParser().getStyle();
        if (this.moduleObject == null) {
            try {
                this.moduleObject = this.muleContext.getRegistry().lookupObject(AssertModuleLifecycleAdapter.class);
                if (this.moduleObject == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
                }
            }
            catch (RegistrationException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure((String)"org.mule.munit.config.AssertModuleLifecycleAdapter"), (Throwable)e, (Initialisable)this);
            }
        }
        if (this.moduleObject instanceof String) {
            this.moduleObject = this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (this.moduleObject == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object by org.mule.munit.config name"), (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    public void setRetryMax(int value) {
        this.retryMax = value;
    }

    public void setMessage(Object value) {
        this.message = value;
    }

    public void setPayloadIs(Object value) {
        this.payloadIs = value;
    }

    public void setPayload(Object value) {
        this.payload = value;
    }

    private void computeClassHierarchy(Class clazz, List classes) {
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            classes.add(current);
            for (Class<?> currentInterface : current.getInterfaces()) {
                this.computeClassHierarchy(currentInterface, classes);
            }
        }
    }

    private boolean isListClass(Class clazz) {
        ArrayList classes = new ArrayList();
        this.computeClassHierarchy(clazz, classes);
        return classes.contains(List.class);
    }

    private boolean isMapClass(Class clazz) {
        ArrayList classes = new ArrayList();
        this.computeClassHierarchy(clazz, classes);
        return classes.contains(Map.class);
    }

    private boolean isList(Type type) {
        if (type instanceof Class && this.isListClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return this.isList(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && this.isList(upperBounds[0]);
        }
        return false;
    }

    private boolean isMap(Type type) {
        if (type instanceof Class && this.isMapClass((Class)type)) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            return this.isMap(((ParameterizedType)type).getRawType());
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return upperBounds.length != 0 && this.isMap(upperBounds[0]);
        }
        return false;
    }

    private boolean isAssignableFrom(Type expectedType, Class clazz) {
        Type[] upperBounds;
        if (expectedType instanceof Class) {
            return ((Class)expectedType).isAssignableFrom(clazz);
        }
        if (expectedType instanceof ParameterizedType) {
            return this.isAssignableFrom(((ParameterizedType)expectedType).getRawType(), clazz);
        }
        if (expectedType instanceof WildcardType && (upperBounds = ((WildcardType)expectedType).getUpperBounds()).length != 0) {
            return this.isAssignableFrom(upperBounds[0], clazz);
        }
        return false;
    }

    private Object evaluate(MuleMessage muleMessage, Object source) {
        if (source instanceof String) {
            String stringSource = (String)source;
            if (stringSource.startsWith(this.patternInfo.getPrefix()) && stringSource.endsWith(this.patternInfo.getSuffix())) {
                return this.expressionManager.evaluate(stringSource, muleMessage);
            }
            return this.expressionManager.parse(stringSource, muleMessage);
        }
        return source;
    }

    private Object evaluateAndTransform(MuleMessage muleMessage, Type expectedType, String expectedMimeType, Object source) throws TransformerException {
        Object valueType;
        if (source == null) {
            return source;
        }
        Cloneable target = null;
        if (this.isList(source.getClass())) {
            if (this.isList(expectedType)) {
                ArrayList<Object> newList = new ArrayList<Object>();
                valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                ListIterator iterator = ((List)source).listIterator();
                while (iterator.hasNext()) {
                    Object subTarget = iterator.next();
                    newList.add(this.evaluateAndTransform(muleMessage, (Type)valueType, expectedMimeType, subTarget));
                }
                target = newList;
            } else {
                target = source;
            }
        } else if (this.isMap(source.getClass())) {
            if (this.isMap(expectedType)) {
                Object keyType = Object.class;
                valueType = Object.class;
                if (expectedType instanceof ParameterizedType) {
                    keyType = ((ParameterizedType)expectedType).getActualTypeArguments()[0];
                    valueType = ((ParameterizedType)expectedType).getActualTypeArguments()[1];
                }
                Map map = (Map)((Object)source);
                HashMap<Object, Object> newMap = new HashMap<Object, Object>();
                Iterator i$ = map.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry entryObj;
                    Map.Entry entry = entryObj = i$.next();
                    Object newKey = this.evaluateAndTransform(muleMessage, (Type)keyType, expectedMimeType, entry.getKey());
                    Object newValue = this.evaluateAndTransform(muleMessage, (Type)valueType, expectedMimeType, entry.getValue());
                    newMap.put(newKey, newValue);
                }
                target = newMap;
            } else {
                target = source;
            }
        } else {
            target = this.evaluate(muleMessage, source);
        }
        if (target != null && !this.isAssignableFrom(expectedType, target.getClass())) {
            DataType sourceDataType = DataTypeFactory.create(target.getClass());
            DataType targetDataType = null;
            targetDataType = expectedMimeType != null ? DataTypeFactory.create((Class)((Class)expectedType), (String)expectedMimeType) : DataTypeFactory.create((Class)((Class)expectedType));
            Transformer t = this.muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
            return t.transform(target);
        }
        return target;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage _muleMessage = event.getMessage();
        AssertModuleLifecycleAdapter castedModuleObject = null;
        if (this.moduleObject instanceof String) {
            castedModuleObject = (AssertModuleLifecycleAdapter)this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate((String)"assertThat"), event, (Throwable)new RuntimeException("Cannot find the configuration specified by the org.mule.munit.config-ref attribute."));
            }
        } else {
            castedModuleObject = (AssertModuleLifecycleAdapter)this.moduleObject;
        }
        try {
            String transformedMessage = (String)this.evaluateAndTransform(_muleMessage, AssertThatMessageProcessor.class.getDeclaredField("_messageType").getGenericType(), null, this.message);
            Object transformedPayloadIs = this.evaluateAndTransform(_muleMessage, AssertThatMessageProcessor.class.getDeclaredField("_payloadIsType").getGenericType(), null, this.payloadIs);
            Object transformedPayload = this.evaluateAndTransform(_muleMessage, AssertThatMessageProcessor.class.getDeclaredField("_payloadType").getGenericType(), null, "#[payload]");
            this.retryCount.getAndIncrement();
            castedModuleObject.assertThat(transformedMessage, transformedPayloadIs, transformedPayload);
            this.retryCount.set(0);
            return event;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)"assertThat"), event, (Throwable)e);
        }
    }
}

