/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.munit.config.AssertModuleLifecycleAdapter;
import org.mule.util.TemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateCallsMessageProcessor
implements FlowConstructAware,
MuleContextAware,
Disposable,
Initialisable,
Startable,
Stoppable,
MessageProcessor {
    private static Logger logger = LoggerFactory.getLogger(ValidateCallsMessageProcessor.class);
    private Object moduleObject;
    private MuleContext muleContext;
    private ExpressionManager expressionManager;
    private TemplateParser.PatternInfo patternInfo;
    private FlowConstruct flowConstruct;
    private AtomicInteger retryCount;
    private int retryMax;

    public void initialise() throws InitialisationException {
        this.retryCount = new AtomicInteger();
        this.expressionManager = this.muleContext.getExpressionManager();
        this.patternInfo = TemplateParser.createMuleStyleParser().getStyle();
        if (this.moduleObject == null) {
            try {
                this.moduleObject = this.muleContext.getRegistry().lookupObject(AssertModuleLifecycleAdapter.class);
                if (this.moduleObject == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
                }
            }
            catch (RegistrationException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure((String)"org.mule.munit.config.AssertModuleLifecycleAdapter"), (Throwable)e, (Initialisable)this);
            }
        }
        if (this.moduleObject instanceof String) {
            this.moduleObject = this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (this.moduleObject == null) {
                throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object by org.mule.munit.config name"), (Initialisable)this);
            }
        }
    }

    public void start() throws MuleException {
    }

    public void stop() throws MuleException {
    }

    public void dispose() {
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    public void setRetryMax(int value) {
        this.retryMax = value;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        AssertModuleLifecycleAdapter castedModuleObject = null;
        if (this.moduleObject instanceof String) {
            castedModuleObject = (AssertModuleLifecycleAdapter)this.muleContext.getRegistry().lookupObject((String)this.moduleObject);
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate((String)"validateCalls"), event, (Throwable)new RuntimeException("Cannot find the configuration specified by the org.mule.munit.config-ref attribute."));
            }
        } else {
            castedModuleObject = (AssertModuleLifecycleAdapter)this.moduleObject;
        }
        try {
            this.retryCount.getAndIncrement();
            castedModuleObject.validateCalls();
            this.retryCount.set(0);
            return event;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)"validateCalls"), event, (Throwable)e);
        }
    }
}

