/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.resource.spi.work.WorkListener;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.munit.config.MunitAfterSuite;
import org.mule.munit.config.MunitAfterTest;
import org.mule.munit.config.MunitBeforeSuite;
import org.mule.munit.config.MunitBeforeTest;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.config.MunitTest;
import org.mule.munit.test.Suite;
import org.mule.munit.test.Test;
import org.mule.munit.test.result.SuiteResult;
import org.mule.munit.test.result.notification.NotificationListener;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.TestingWorkListener;
import org.mule.util.ClassUtils;

public class MunitTestRunner {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.org.mule.munit.config.AnnotationsConfigurationBuilder";
    private String resources;
    private MuleContext muleContext;
    private Suite suite;

    public MunitTestRunner(String resources) {
        this.resources = resources;
        try {
            this.muleContext = this.createMuleContext();
            this.muleContext.start();
            this.suite = new Suite(resources);
            List<MunitFlow> before = this.lookupFlows(MunitBeforeTest.class);
            List<MunitFlow> after = this.lookupFlows(MunitAfterTest.class);
            List<MunitFlow> flowConstructs = this.lookupFlows(MunitTest.class);
            for (MunitFlow flowConstruct : flowConstructs) {
                this.suite.add(new Test(before, flowConstruct, after));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected MuleContext createMuleContext() throws Exception {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builders = new ArrayList<Object>();
        builders.add(new SimpleConfigurationBuilder(null));
        if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, this.getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, this.getClass()));
        }
        builders.add(this.getBuilder());
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContext((MuleContextBuilder)contextBuilder);
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        return context;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(this.resources);
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    private List<MunitFlow> lookupFlows(Class munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }

    public SuiteResult run() {
        try {
            this.process(this.lookupFlows(MunitBeforeSuite.class), this.muleEvent());
            SuiteResult result = this.suite.run();
            this.process(this.lookupFlows(MunitAfterSuite.class), this.muleEvent());
            this.muleContext.stop();
            this.muleContext.dispose();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not Run the suite", e);
        }
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.suite.setNotificationListener(notificationListener);
    }

    private MuleEvent muleEvent() {
        try {
            return MuleTestUtils.getTestEvent(null, (MessageExchangePattern)MessageExchangePattern.REQUEST_RESPONSE, (MuleContext)this.muleContext);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void process(Collection<MunitFlow> flowConstructs, MuleEvent event) throws MuleException {
        for (MunitFlow flowConstruct : flowConstructs) {
            System.out.printf("%n" + flowConstruct.getDescription() + "%n", new Object[0]);
            flowConstruct.process(event);
        }
    }

    public int getNumberOfTests() {
        return this.suite.getNumberOfTests();
    }
}

