/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.test.result;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.test.result.MunitResult;

public class SuiteResult
implements MunitResult {
    private List<MunitResult> results = new ArrayList<MunitResult>();
    private String name;

    public SuiteResult(String name) {
        this.name = name;
    }

    @Override
    public boolean hasSucceded() {
        for (MunitResult result : this.results) {
            if (result.hasSucceded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfFailures() {
        int failures = 0;
        for (MunitResult result : this.results) {
            failures += result.getNumberOfFailures();
        }
        return failures;
    }

    @Override
    public int getNumberOfErrors() {
        int errors = 0;
        for (MunitResult result : this.results) {
            errors += result.getNumberOfErrors();
        }
        return errors;
    }

    @Override
    public String getTestName() {
        return this.name;
    }

    public List<MunitResult> getFailingTests() {
        ArrayList<MunitResult> failingTests = new ArrayList<MunitResult>();
        for (MunitResult result : this.results) {
            if (result.getNumberOfFailures() <= 0) continue;
            failingTests.add(result);
        }
        return failingTests;
    }

    public List<MunitResult> getErrorTests() {
        ArrayList<MunitResult> errorTests = new ArrayList<MunitResult>();
        for (MunitResult result : this.results) {
            if (result.getNumberOfErrors() <= 0) continue;
            errorTests.add(result);
        }
        return errorTests;
    }

    public void add(MunitResult result) {
        this.results.add(result);
    }
}

