/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.test.result.notification;

import java.io.PrintStream;
import org.mule.munit.test.Test;
import org.mule.munit.test.result.TestResult;
import org.mule.munit.test.result.notification.Notification;
import org.mule.munit.test.result.notification.NotificationListener;

public class StreamNotificationListener
implements NotificationListener {
    private PrintStream out;
    private boolean debugMode;

    public StreamNotificationListener(PrintStream out) {
        this.out = out;
    }

    @Override
    public void notifyStartOf(Test test) {
        this.out.println("RUNNIG " + test.getName());
    }

    @Override
    public void notify(TestResult testResult) {
        Notification notification = null;
        if (testResult.getNumberOfErrors() > 0) {
            this.out.println("ERROR - The test " + testResult.getTestName() + " finished with an Error.");
            this.out.flush();
            notification = testResult.getError();
        } else if (testResult.getFailure() != null) {
            this.out.println("FAILURE - The test " + testResult.getTestName() + " finished with a Failure.");
            this.out.flush();
            notification = testResult.getFailure();
        }
        if (notification != null) {
            this.out.println(notification.getShortMessage());
            this.out.flush();
            if (this.debugMode) {
                this.out.println(notification.getFullMessage());
            }
        } else {
            this.out.println("SUCCESS - Test " + testResult.getTestName() + " finished Successfully.");
            this.out.flush();
        }
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

