/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.munit.AssertModule;
import org.mule.util.TemplateParser;

public abstract class MunitMessageProcessor
implements Initialisable,
MessageProcessor,
MuleContextAware {
    protected Object moduleObject;
    protected MuleContext muleContext;
    protected ExpressionManager expressionManager;
    protected TemplateParser.PatternInfo patternInfo;
    protected AtomicInteger retryCount;
    protected int retryMax;

    public void initialise() throws InitialisationException {
        this.retryCount = new AtomicInteger();
        this.expressionManager = this.muleContext.getExpressionManager();
        this.patternInfo = TemplateParser.createMuleStyleParser().getStyle();
        if (this.moduleObject == null) {
            try {
                this.moduleObject = this.muleContext.getRegistry().lookupObject(AssertModule.class);
                if (this.moduleObject == null) {
                    throw new InitialisationException(MessageFactory.createStaticMessage((String)"Cannot find object"), (Initialisable)this);
                }
            }
            catch (RegistrationException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure((String)"org.mule.munit.AssertModule"), (Throwable)e, (Initialisable)this);
            }
        }
    }

    protected AssertModule getModule(MuleEvent event, String methodName) throws MessagingException {
        AssertModule castedModuleObject;
        if (this.moduleObject instanceof String) {
            castedModuleObject = (AssertModule)((Object)this.muleContext.getRegistry().lookupObject((String)this.moduleObject));
            if (castedModuleObject == null) {
                throw new MessagingException(CoreMessages.failedToCreate((String)methodName), event, (Throwable)new RuntimeException("Cannot find the configuration specified by the org.mule.munit.config-ref attribute."));
            }
        } else {
            castedModuleObject = (AssertModule)((Object)this.moduleObject);
        }
        return castedModuleObject;
    }

    protected Object evaluate(MuleMessage muleMessage, Object source) {
        if (source instanceof String) {
            String stringSource = (String)source;
            if (stringSource.startsWith(this.patternInfo.getPrefix()) && stringSource.endsWith(this.patternInfo.getSuffix())) {
                return this.expressionManager.evaluate(stringSource, muleMessage);
            }
            return this.expressionManager.parse(stringSource, muleMessage);
        }
        return source;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage mulemessage = event.getMessage();
        AssertModule module = this.getModule(event, this.getProcessor());
        try {
            this.retryCount.getAndIncrement();
            this.doProcess(mulemessage, module);
            this.retryCount.set(0);
            return event;
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke((String)this.getProcessor()), event, (Throwable)e);
        }
    }

    protected abstract void doProcess(MuleMessage var1, AssertModule var2);

    protected abstract String getProcessor();

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setModuleObject(Object moduleObject) {
        this.moduleObject = moduleObject;
    }

    public void setRetryMax(int value) {
        this.retryMax = value;
    }
}

