/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.expression.ExpressionManager;
import org.mule.munit.common.MunitCore;
import org.mule.munit.config.MunitFlow;

public class MunitTestFlow
extends MunitFlow {
    private boolean ignore;
    private String expectExceptionThatSatisfies;

    public MunitTestFlow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.registerMpManager(muleContext);
    }

    public String getExpectExceptionThatSatisfies() {
        return this.expectExceptionThatSatisfies;
    }

    public void setExpectExceptionThatSatisfies(String expectExceptionThatSatisfies) {
        this.expectExceptionThatSatisfies = expectExceptionThatSatisfies;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    private boolean expectException(Throwable t) {
        Exception causeException;
        String className = t.getClass().getName();
        if (t instanceof MessagingException && (causeException = ((MessagingException)t).getCauseException()) != null) {
            className = causeException.getClass().getName();
        }
        Assert.assertEquals((String)this.expectExceptionThatSatisfies, (String)className);
        return true;
    }

    public boolean expectException(Throwable t, MuleEvent event) {
        if (!StringUtils.isEmpty((String)this.expectExceptionThatSatisfies)) {
            ExpressionManager expressionManager = this.muleContext.getExpressionManager();
            if (expressionManager.isExpression(this.expectExceptionThatSatisfies)) {
                Boolean expressionResult = (Boolean)expressionManager.evaluate(this.expectExceptionThatSatisfies, event);
                if (!expressionResult.booleanValue()) {
                    Assert.fail((String)"The exception does not match your MEL expression");
                }
                return true;
            }
            return this.expectException(t);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            MuleEvent process;
            MuleEvent muleEvent = process = super.process(event);
            return muleEvent;
        }
        finally {
            MunitCore.reset((MuleContext)this.muleContext);
        }
    }

    private void registerMpManager(MuleContext muleContext) {
        MunitCore.registerManager((MuleContext)muleContext);
    }
}

