/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config.spring;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.munit.AssertModule;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssertModuleConfigDefinitionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContent) {
        List excludedFlows;
        String connectors;
        String integration;
        String name = element.getAttribute("name");
        if (name == null || StringUtils.isBlank((String)name)) {
            element.setAttribute("name", AutoIdUtils.getUniqueName((Element)element, (String)"mule-bean"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)AssertModule.class.getName());
        if (Initialisable.class.isAssignableFrom(AssertModule.class)) {
            builder.setInitMethodName("initialise");
        }
        if (Disposable.class.isAssignableFrom(AssertModule.class)) {
            builder.setDestroyMethodName("dispose");
        }
        if (Boolean.valueOf(integration = element.getAttribute("mock-inbounds")).booleanValue()) {
            builder.addPropertyValue("mockInbounds", (Object)Boolean.TRUE);
        }
        if (Boolean.valueOf(connectors = element.getAttribute("mock-connectors")).booleanValue()) {
            builder.addPropertyValue("mockConnectors", (Object)Boolean.TRUE);
        }
        ArrayList<String> flowNames = new ArrayList<String>();
        Element exclusions = DomUtils.getChildElementByTagName((Element)element, (String)"exclude-inbound-mocking");
        if (exclusions != null && (excludedFlows = DomUtils.getChildElementsByTagName((Element)exclusions, (String)"flow-name")) != null) {
            for (Element excludedFlow : excludedFlows) {
                Node valueNode = excludedFlow.getFirstChild();
                if (valueNode == null || valueNode.getNodeValue() == null) continue;
                flowNames.add(valueNode.getNodeValue());
            }
        }
        builder.addPropertyValue("mockingExcludedFlows", flowNames);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE", (Object)Boolean.TRUE);
        return definition;
    }
}

