/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.spring;

import java.util.Map;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;

public class BeanFactoryMethodBuilder {
    private AbstractBeanDefinition beanDefinition;

    public BeanFactoryMethodBuilder(AbstractBeanDefinition beanDefinition, String factoryMethodName, String beanFactoryName) {
        this.beanDefinition = beanDefinition;
        beanDefinition.setFactoryBeanName(beanFactoryName);
        beanDefinition.setFactoryMethodName(factoryMethodName);
    }

    public AbstractBeanDefinition withConstructorArguments(Object ... constructorArguments) {
        int argumentsSize = constructorArguments.length;
        ConstructorArgumentValues constructorArgumentValues = this.beanDefinition.getConstructorArgumentValues();
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        Map indexedArgumentValues = constructorArgumentValues.getIndexedArgumentValues();
        for (Integer i : indexedArgumentValues.keySet()) {
            values.addIndexedArgumentValue(i + argumentsSize, (ConstructorArgumentValues.ValueHolder)indexedArgumentValues.get(i));
        }
        for (int i = 0; i < argumentsSize; ++i) {
            values.addIndexedArgumentValue(i, constructorArguments[i]);
        }
        this.beanDefinition.setConstructorArgumentValues(values);
        return this.beanDefinition;
    }
}

