/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.mp.MessageProcessorCall;
import org.mule.munit.common.mp.MockedMessageProcessorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitCore {
    public static final String LINE_NUMBER_ELEMENT_ATTRIBUTE = "__MUNIT_LINE_NUMBER";
    private static MuleContext context;

    public static synchronized void setMuleContext(MuleContext muleContext) {
        context = muleContext;
    }

    public static MuleContext getMuleContext() {
        return context;
    }

    public static void reset(MuleContext muleContext) {
        MockEndpointManager endpointFactory = (MockEndpointManager)muleContext.getRegistry().lookupObject("_muleEndpointFactory");
        endpointFactory.resetBehaviors();
        MockedMessageProcessorManager mpManager = (MockedMessageProcessorManager)muleContext.getRegistry().lookupObject(MockedMessageProcessorManager.ID);
        if (mpManager != null) {
            mpManager.reset();
        }
    }

    public static void registerManager(MuleContext muleContext) {
        try {
            MuleRegistry registry = muleContext.getRegistry();
            if (registry.lookupObject(MockedMessageProcessorManager.ID) == null) {
                registry.registerObject(MockedMessageProcessorManager.ID, (Object)new MockedMessageProcessorManager());
            }
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<StackTraceElement> buildMuleStackTrace(MuleContext muleContext) {
        MockedMessageProcessorManager manager = (MockedMessageProcessorManager)muleContext.getRegistry().lookupObject(MockedMessageProcessorManager.ID);
        List<MessageProcessorCall> calls = manager.getCalls();
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>();
        StringBuffer stackTrace = new StringBuffer();
        for (MessageProcessorCall call : calls) {
            stackTraceElements.add(0, new StackTraceElement(MunitCore.getFlowConstructName(call), MunitCore.getFullName(call), call.getFileName(), MunitCore.lineNumber(call)));
            stackTrace.insert(0, call.getMessageProcessorId().getFullName());
        }
        return stackTraceElements;
    }

    private static Integer lineNumber(MessageProcessorCall call) {
        String lineNumber = call.getLineNumber();
        if (lineNumber == null) {
            return 0;
        }
        return Integer.valueOf(lineNumber);
    }

    private static String getFullName(MessageProcessorCall call) {
        String fullName = call.getMessageProcessorId().getFullName();
        Map<String, Object> attributes = call.getAttributes();
        attributes.toString();
        attributes.remove("name");
        attributes.remove(LINE_NUMBER_ELEMENT_ATTRIBUTE);
        return fullName + attributes.toString();
    }

    private static String getFlowConstructName(MessageProcessorCall call) {
        FlowConstruct flowConstruct = call.getFlowConstruct();
        if (flowConstruct == null) {
            return "";
        }
        return flowConstruct.getName();
    }
}

