/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.mp.MessageProcessorCall;
import org.mule.munit.common.mp.MessageProcessorId;
import org.mule.munit.common.mp.MockedMessageProcessorBehavior;
import org.mule.munit.common.mp.MockedMessageProcessorManager;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitMessageProcessorInterceptor
implements MethodInterceptor {
    private MessageProcessorId id;
    private Map<String, String> attributes;
    private String fileName;
    private String lineNumber;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent event = (MuleEvent)args[0];
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager();
        MessageProcessorCall messageProcessorCall = this.buildCall(event);
        this.registerCall(manager, messageProcessorCall);
        this.runSpyBeforeAssertions(manager, event);
        MockedMessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.runSpyAfterAssertions(manager, event);
                throw behavior.getExceptionToThrow();
            }
            MunitUtils.copyMessage((DefaultMuleMessage)behavior.getReturnMuleMessage(), (DefaultMuleMessage)event.getMessage());
            this.runSpyAfterAssertions(manager, event);
            return event;
        }
        this.runSpyAfterAssertions(manager, event);
        return proxy.invokeSuper(obj, args);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        if (MessageProcessor.class.isAssignableFrom(declaringClass) && method.getName().equals("process")) {
            return this.process(obj, args, proxy);
        }
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAfterAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getAfterMessageProcessors());
    }

    private void runSpyBeforeAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getBeforeMessageProcessors());
    }

    private SpyAssertion getAssertionFrom(MockedMessageProcessorManager manager) {
        Map<MessageProcessorId, SpyAssertion> assertions = manager.getSpyAssertions();
        if (assertions.isEmpty()) {
            return null;
        }
        SpyAssertion spyAssertion = assertions.get(this.id);
        if (spyAssertion == null) {
            return null;
        }
        return spyAssertion;
    }

    private MessageProcessorCall buildCall(MuleEvent event) {
        MessageProcessorCall call = new MessageProcessorCall(this.id);
        HashMap<String, Object> processed = new HashMap<String, Object>();
        for (Map.Entry<String, String> attrs : this.attributes.entrySet()) {
            try {
                Object evaluate = this.evaluate(attrs.getValue(), event);
                processed.put(attrs.getKey(), evaluate);
            }
            catch (Throwable t) {
                processed.put(attrs.getKey(), attrs.getValue());
            }
        }
        call.setAttributes(processed);
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    private Object evaluate(String elementValue, MuleEvent event) {
        Object o;
        Object compareTo = elementValue;
        ExpressionManager expressionManager = this.getMuleContext().getExpressionManager();
        if (expressionManager.isExpression(elementValue)) {
            compareTo = expressionManager.parse(elementValue, event);
        } else if (!StringUtils.isEmpty((String)elementValue) && (o = this.getMuleContext().getRegistry().lookupObject(elementValue)) != null) {
            compareTo = o;
        }
        return compareTo;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager() {
        return (MockedMessageProcessorManager)this.getMuleContext().getRegistry().lookupObject(MockedMessageProcessorManager.ID);
    }

    public void setId(MessageProcessorId id) {
        this.id = id;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public MuleContext getMuleContext() {
        return MunitCore.getMuleContext();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }
}

