/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.util.Map;
import net.sf.cglib.proxy.MethodProxy;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.modules.interceptor.processors.AbstractMessageProcessorInterceptor;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.mp.MockedMessageProcessorManager;
import org.mule.munit.common.mp.MunitMessageProcessorCall;
import org.mule.munit.common.mp.SpyAssertion;

public class MunitMessageProcessorInterceptor
extends AbstractMessageProcessorInterceptor {
    private String fileName;
    private String lineNumber;

    public Object process(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        MuleEvent event = (MuleEvent)args[0];
        MockedMessageProcessorManager manager = this.getMockedMessageProcessorManager();
        MunitMessageProcessorCall messageProcessorCall = this.buildCall(event);
        this.runSpyBeforeAssertions(manager, event);
        this.registerCall(manager, messageProcessorCall);
        MessageProcessorBehavior behavior = manager.getBetterMatchingBehavior(messageProcessorCall);
        if (behavior != null) {
            if (behavior.getExceptionToThrow() != null) {
                this.runSpyAfterAssertions(manager, event);
                throw behavior.getExceptionToThrow();
            }
            MunitUtils.copyMessage((DefaultMuleMessage)behavior.getReturnMuleMessage(), (DefaultMuleMessage)event.getMessage());
            this.runSpyAfterAssertions(manager, event);
            return event;
        }
        this.runSpyAfterAssertions(manager, event);
        return proxy.invokeSuper(obj, args);
    }

    private void registerCall(MockedMessageProcessorManager manager, MunitMessageProcessorCall messageProcessorCall) {
        manager.addCall(messageProcessorCall);
    }

    private void runSpyAfterAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getAfterMessageProcessors());
    }

    private void runSpyBeforeAssertions(MockedMessageProcessorManager manager, MuleEvent event) {
        SpyAssertion spyAssertion = this.getAssertionFrom(manager);
        if (spyAssertion == null) {
            return;
        }
        MunitUtils.verifyAssertions(event, spyAssertion.getBeforeMessageProcessors());
    }

    private SpyAssertion getAssertionFrom(MockedMessageProcessorManager manager) {
        Map<MessageProcessorId, SpyAssertion> assertions = manager.getSpyAssertions();
        if (assertions.isEmpty()) {
            return null;
        }
        SpyAssertion spyAssertion = assertions.get(this.id);
        if (spyAssertion == null) {
            return null;
        }
        return spyAssertion;
    }

    private MunitMessageProcessorCall buildCall(MuleEvent event) {
        MunitMessageProcessorCall call = new MunitMessageProcessorCall(this.id);
        call.setAttributes(this.getAttributes(event));
        call.setFlowConstruct(event.getFlowConstruct());
        call.setFileName(this.fileName);
        call.setLineNumber(this.lineNumber);
        return call;
    }

    protected MockedMessageProcessorManager getMockedMessageProcessorManager() {
        return (MockedMessageProcessorManager)((Object)this.getMuleContext().getRegistry().lookupObject(MockedMessageProcessorManager.ID));
    }

    public MuleContext getMuleContext() {
        return MunitCore.getMuleContext();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLineNumber(String lineNumber) {
        this.lineNumber = lineNumber;
    }
}

