/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common;

import java.util.List;
import java.util.Set;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.common.mocking.NotDefinedPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitUtils {
    public static void copyMessage(DefaultMuleMessage original, DefaultMuleMessage copyToMessage) {
        Object payload = original.getPayload();
        if (payload != null && !NotDefinedPayload.isNotDefined(payload)) {
            copyToMessage.setPayload(payload);
        }
        if (MunitUtils.containsProperties(original.getInboundPropertyNames())) {
            for (String property : original.getInboundPropertyNames()) {
                copyToMessage.setInboundProperty(property, original.getInboundProperty(property));
            }
        }
        if (MunitUtils.containsProperties(original.getSessionPropertyNames())) {
            for (String property : original.getSessionPropertyNames()) {
                copyToMessage.setSessionProperty(property, original.getSessionProperty(property));
            }
        }
        if (MunitUtils.containsProperties(original.getInvocationPropertyNames())) {
            for (String property : original.getInvocationPropertyNames()) {
                copyToMessage.setInvocationProperty(property, original.getInvocationProperty(property));
            }
        }
        if (MunitUtils.containsProperties(original.getOutboundPropertyNames())) {
            for (String property : original.getOutboundPropertyNames()) {
                copyToMessage.setOutboundProperty(property, original.getOutboundProperty(property));
            }
        }
    }

    private static boolean containsProperties(Set<String> inboundPropertyNames) {
        return inboundPropertyNames != null && !inboundPropertyNames.isEmpty();
    }

    public static void verifyAssertions(MuleEvent event, List<MessageProcessor> assertions) {
        if (assertions == null) {
            return;
        }
        for (MessageProcessor processor : assertions) {
            try {
                processor.process(event);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

