/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMD
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(RMD.class);

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        session.resetState();
        String fileName = request.getArgument();
        if (fileName == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "RMD", null));
            return;
        }
        FtpFile file = null;
        try {
            file = session.getFileSystemView().getFile(fileName);
        }
        catch (Exception ex) {
            this.LOG.debug("Exception getting file object", (Throwable)ex);
        }
        if (file == null) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "RMD.permission", fileName));
            return;
        }
        fileName = file.getAbsolutePath();
        if (!file.isDirectory()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "RMD.invalid", fileName));
            return;
        }
        FtpFile cwd = session.getFileSystemView().getWorkingDirectory();
        if (file.equals(cwd)) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 450, "RMD.busy", fileName));
            return;
        }
        if (!file.isRemovable()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "RMD.permission", fileName));
            return;
        }
        if (file.delete()) {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 250, "RMD", fileName));
            String userName = session.getUser().getName();
            this.LOG.info("Directory remove : " + userName + " - " + fileName);
            ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
            ftpStat.setRmdir(session, file);
        } else {
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 450, "RMD", fileName));
        }
    }
}

