/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STOR
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(STOR.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            long skipLen = session.getFileOffset();
            String fileName = request.getArgument();
            if (fileName == null) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 501, "STOR", null));
                return;
            }
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception ex) {
                this.LOG.debug("Exception getting file object", (Throwable)ex);
            }
            if (file == null) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "STOR.invalid", fileName));
                return;
            }
            fileName = file.getAbsolutePath();
            if (!file.isWritable()) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 550, "STOR.permission", fileName));
                return;
            }
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 150, "STOR", fileName)).awaitUninterruptibly(10000L);
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the input data stream", (Throwable)e);
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 425, "STOR", fileName));
                session.resetState();
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            OutputStream outStream = null;
            try {
                outStream = file.createOutputStream(skipLen);
                long transSz = dataConnection.transferFromClient(session.getFtpletSession(), outStream);
                if (outStream != null) {
                    outStream.close();
                }
                this.LOG.info("File uploaded {}", (Object)fileName);
                ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                ftpStat.setUpload(session, file, transSz);
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 426, "STOR", fileName));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during data transfer", (Throwable)ex);
                failure = true;
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 551, "STOR", fileName));
            }
            finally {
                IoUtils.close(outStream);
            }
            if (!failure) {
                session.write((Object)LocalizedFtpReply.translate(session, request, context, 226, "STOR", fileName));
            }
        }
        finally {
            session.resetState();
            session.getDataConnection().closeDataConnection();
        }
    }
}

