/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.impl.FileObserver;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.apache.ftpserver.impl.StatisticsObserver;

public class DefaultFtpStatistics
implements ServerFtpStatistics {
    private StatisticsObserver observer = null;
    private FileObserver fileObserver = null;
    private Date startTime = new Date();
    private AtomicInteger uploadCount = new AtomicInteger(0);
    private AtomicInteger downloadCount = new AtomicInteger(0);
    private AtomicInteger deleteCount = new AtomicInteger(0);
    private AtomicInteger mkdirCount = new AtomicInteger(0);
    private AtomicInteger rmdirCount = new AtomicInteger(0);
    private AtomicInteger currLogins = new AtomicInteger(0);
    private AtomicInteger totalLogins = new AtomicInteger(0);
    private AtomicInteger totalFailedLogins = new AtomicInteger(0);
    private AtomicInteger currAnonLogins = new AtomicInteger(0);
    private AtomicInteger totalAnonLogins = new AtomicInteger(0);
    private AtomicInteger currConnections = new AtomicInteger(0);
    private AtomicInteger totalConnections = new AtomicInteger(0);
    private AtomicLong bytesUpload = new AtomicLong(0L);
    private AtomicLong bytesDownload = new AtomicLong(0L);
    private Map<String, UserLogins> userLoginTable = new ConcurrentHashMap<String, UserLogins>();
    public static final String LOGIN_NUMBER = "login_number";

    public void setObserver(StatisticsObserver observer) {
        this.observer = observer;
    }

    public void setFileObserver(FileObserver observer) {
        this.fileObserver = observer;
    }

    public Date getStartTime() {
        if (this.startTime != null) {
            return (Date)this.startTime.clone();
        }
        return null;
    }

    public int getTotalUploadNumber() {
        return this.uploadCount.get();
    }

    public int getTotalDownloadNumber() {
        return this.downloadCount.get();
    }

    public int getTotalDeleteNumber() {
        return this.deleteCount.get();
    }

    public long getTotalUploadSize() {
        return this.bytesUpload.get();
    }

    public long getTotalDownloadSize() {
        return this.bytesDownload.get();
    }

    public int getTotalDirectoryCreated() {
        return this.mkdirCount.get();
    }

    public int getTotalDirectoryRemoved() {
        return this.rmdirCount.get();
    }

    public int getTotalConnectionNumber() {
        return this.totalConnections.get();
    }

    public int getCurrentConnectionNumber() {
        return this.currConnections.get();
    }

    public int getTotalLoginNumber() {
        return this.totalLogins.get();
    }

    public int getTotalFailedLoginNumber() {
        return this.totalFailedLogins.get();
    }

    public int getCurrentLoginNumber() {
        return this.currLogins.get();
    }

    public int getTotalAnonymousLoginNumber() {
        return this.totalAnonLogins.get();
    }

    public int getCurrentAnonymousLoginNumber() {
        return this.currAnonLogins.get();
    }

    public synchronized int getCurrentUserLoginNumber(User user) {
        UserLogins userLogins = this.userLoginTable.get(user.getName());
        if (userLogins == null) {
            return 0;
        }
        return userLogins.totalLogins.get();
    }

    public synchronized int getCurrentUserLoginNumber(User user, InetAddress ipAddress) {
        UserLogins userLogins = this.userLoginTable.get(user.getName());
        if (userLogins == null) {
            return 0;
        }
        return userLogins.loginsFromInetAddress(ipAddress).get();
    }

    public synchronized void setUpload(FtpIoSession session, FtpFile file, long size) {
        this.uploadCount.incrementAndGet();
        this.bytesUpload.addAndGet(size);
        this.notifyUpload(session, file, size);
    }

    public synchronized void setDownload(FtpIoSession session, FtpFile file, long size) {
        this.downloadCount.incrementAndGet();
        this.bytesDownload.addAndGet(size);
        this.notifyDownload(session, file, size);
    }

    public synchronized void setDelete(FtpIoSession session, FtpFile file) {
        this.deleteCount.incrementAndGet();
        this.notifyDelete(session, file);
    }

    public synchronized void setMkdir(FtpIoSession session, FtpFile file) {
        this.mkdirCount.incrementAndGet();
        this.notifyMkdir(session, file);
    }

    public synchronized void setRmdir(FtpIoSession session, FtpFile file) {
        this.rmdirCount.incrementAndGet();
        this.notifyRmdir(session, file);
    }

    public synchronized void setOpenConnection(FtpIoSession session) {
        this.currConnections.incrementAndGet();
        this.totalConnections.incrementAndGet();
        this.notifyOpenConnection(session);
    }

    public synchronized void setCloseConnection(FtpIoSession session) {
        if (this.currConnections.get() > 0) {
            this.currConnections.decrementAndGet();
        }
        this.notifyCloseConnection(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLogin(FtpIoSession session) {
        this.currLogins.incrementAndGet();
        this.totalLogins.incrementAndGet();
        User user = session.getUser();
        if ("anonymous".equals(user.getName())) {
            this.currAnonLogins.incrementAndGet();
            this.totalAnonLogins.incrementAndGet();
        }
        User user2 = user;
        synchronized (user2) {
            UserLogins statisticsTable = this.userLoginTable.get(user.getName());
            if (statisticsTable == null) {
                InetAddress address = null;
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
                }
                statisticsTable = new UserLogins(address);
                this.userLoginTable.put(user.getName(), statisticsTable);
            } else {
                statisticsTable.totalLogins.incrementAndGet();
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    InetAddress address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
                    statisticsTable.loginsFromInetAddress(address).incrementAndGet();
                }
            }
        }
        this.notifyLogin(session);
    }

    public synchronized void setLoginFail(FtpIoSession session) {
        this.totalFailedLogins.incrementAndGet();
        this.notifyLoginFail(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLogout(FtpIoSession session) {
        User user = session.getUser();
        if (user == null) {
            return;
        }
        this.currLogins.decrementAndGet();
        if ("anonymous".equals(user.getName())) {
            this.currAnonLogins.decrementAndGet();
        }
        User user2 = user;
        synchronized (user2) {
            UserLogins userLogins = this.userLoginTable.get(user.getName());
            if (userLogins != null) {
                userLogins.totalLogins.decrementAndGet();
                if (session.getRemoteAddress() instanceof InetSocketAddress) {
                    InetAddress address = ((InetSocketAddress)session.getRemoteAddress()).getAddress();
                    userLogins.loginsFromInetAddress(address).decrementAndGet();
                }
            }
        }
        this.notifyLogout(session);
    }

    private void notifyUpload(FtpIoSession session, FtpFile file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyUpload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyUpload(session, file, size);
        }
    }

    private void notifyDownload(FtpIoSession session, FtpFile file, long size) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDownload();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDownload(session, file, size);
        }
    }

    private void notifyDelete(FtpIoSession session, FtpFile file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyDelete();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyDelete(session, file);
        }
    }

    private void notifyMkdir(FtpIoSession session, FtpFile file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyMkdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyMkdir(session, file);
        }
    }

    private void notifyRmdir(FtpIoSession session, FtpFile file) {
        FileObserver fileObserver;
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyRmdir();
        }
        if ((fileObserver = this.fileObserver) != null) {
            fileObserver.notifyRmdir(session, file);
        }
    }

    private void notifyOpenConnection(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyOpenConnection();
        }
    }

    private void notifyCloseConnection(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            observer.notifyCloseConnection();
        }
    }

    private void notifyLogin(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = session.getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogin(anonymous);
        }
    }

    private void notifyLoginFail(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null && session.getRemoteAddress() instanceof InetSocketAddress) {
            observer.notifyLoginFail(((InetSocketAddress)session.getRemoteAddress()).getAddress());
        }
    }

    private void notifyLogout(FtpIoSession session) {
        StatisticsObserver observer = this.observer;
        if (observer != null) {
            User user = session.getUser();
            boolean anonymous = false;
            if (user != null) {
                String login = user.getName();
                anonymous = login != null && login.equals("anonymous");
            }
            observer.notifyLogout(anonymous);
        }
    }

    public synchronized void resetStatisticsCounters() {
        this.startTime = new Date();
        this.uploadCount.set(0);
        this.downloadCount.set(0);
        this.deleteCount.set(0);
        this.mkdirCount.set(0);
        this.rmdirCount.set(0);
        this.totalLogins.set(0);
        this.totalFailedLogins.set(0);
        this.totalAnonLogins.set(0);
        this.totalConnections.set(0);
        this.bytesUpload.set(0L);
        this.bytesDownload.set(0L);
    }

    private static class UserLogins {
        private Map<InetAddress, AtomicInteger> perAddress = new ConcurrentHashMap<InetAddress, AtomicInteger>();
        public AtomicInteger totalLogins = new AtomicInteger(1);

        public UserLogins(InetAddress address) {
            this.perAddress.put(address, new AtomicInteger(1));
        }

        public AtomicInteger loginsFromInetAddress(InetAddress address) {
            AtomicInteger logins = this.perAddress.get(address);
            if (logins == null) {
                logins = new AtomicInteger(0);
                this.perAddress.put(address, logins);
            }
            return logins;
        }
    }
}

