/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public final class TransactionResourceImpl {
    protected ContextManager cm;
    protected ContextService csf;
    protected String username;
    private String dbname;
    private InternalDriver driver;
    private String url;
    private String drdaID;
    protected Database database;
    protected LanguageConnectionContext lcc;

    TransactionResourceImpl(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        this.driver = internalDriver;
        this.csf = internalDriver.getContextServiceFactory();
        this.dbname = InternalDriver.getDatabaseName(string, properties);
        this.url = string;
        this.username = IdUtil.getUserNameFromURLProps(properties);
        this.drdaID = properties.getProperty("drdaID", null);
        this.cm = this.csf.newContextManager();
    }

    void setDatabase(Database database) {
        this.database = database;
    }

    void startTransaction() throws StandardException, SQLException {
        this.lcc = this.database.setupConnection(this.cm, this.username, this.drdaID, this.dbname);
    }

    InternalDriver getDriver() {
        return this.driver;
    }

    ContextService getCsf() {
        return this.csf;
    }

    ContextManager getContextManager() {
        return this.cm;
    }

    LanguageConnectionContext getLcc() {
        return this.lcc;
    }

    String getDBName() {
        return this.dbname;
    }

    String getUrl() {
        return this.url;
    }

    Database getDatabase() {
        return this.database;
    }

    StandardException shutdownDatabaseException() {
        StandardException standardException = StandardException.newException("08006.D", this.getDBName());
        standardException.setReport(1);
        return standardException;
    }

    void commit() throws StandardException {
        this.lcc.userCommit();
    }

    void rollback() throws StandardException {
        if (this.lcc != null) {
            this.lcc.userRollback();
        }
    }

    void clearContextInError() {
        this.csf.resetCurrentContextManager(this.cm);
        this.cm = null;
    }

    void clearLcc() {
        this.lcc = null;
    }

    final void setupContextStack() {
        this.csf.setCurrentContextManager(this.cm);
    }

    final void restoreContextStack() {
        if (this.csf == null || this.cm == null) {
            return;
        }
        this.csf.resetCurrentContextManager(this.cm);
    }

    final SQLException handleException(Throwable throwable, boolean bl, boolean bl2) throws SQLException {
        try {
            if (throwable instanceof SQLException) {
                InterruptStatus.restoreIntrFlagIfSeen();
                return (SQLException)throwable;
            }
            boolean bl3 = false;
            if (throwable instanceof StandardException) {
                StandardException standardException = (StandardException)throwable;
                int n = standardException.getSeverity();
                if (n <= 20000) {
                    if (bl && bl2) {
                        standardException.setSeverity(30000);
                    }
                } else if ("08000".equals(standardException.getMessageId())) {
                    bl3 = true;
                }
            }
            if (this.cm != null) {
                boolean bl4 = this.cleanupOnError(throwable, this.database != null ? this.database.isActive() : false);
                if (bl3 && bl4) {
                    throwable = this.shutdownDatabaseException();
                }
            }
            InterruptStatus.restoreIntrFlagIfSeen();
            return TransactionResourceImpl.wrapInSQLException(throwable);
        }
        catch (Throwable throwable2) {
            if (this.cm != null) {
                this.cm.cleanupOnError(throwable2, this.database != null ? this.isActive() : false);
            }
            InterruptStatus.restoreIntrFlagIfSeen();
            throw TransactionResourceImpl.wrapInSQLException(throwable2);
        }
    }

    public static SQLException wrapInSQLException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            if (standardException.getCause() == null) {
                return Util.generateCsSQLException(standardException);
            }
            return Util.seeNextException(standardException.getMessageId(), standardException.getArguments(), TransactionResourceImpl.wrapInSQLException(standardException.getCause()));
        }
        return Util.javaException(throwable);
    }

    String getUserName() {
        return this.username;
    }

    boolean cleanupOnError(Throwable throwable, boolean bl) {
        return this.cm.cleanupOnError(throwable, bl);
    }

    boolean isIdle() {
        return this.lcc == null || this.lcc.getTransactionExecute().isIdle();
    }

    boolean isActive() {
        return this.driver.isActive() && (this.database == null || this.database.isActive());
    }
}

