/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class TemporaryRowHolderResultSet
implements CursorResultSet,
NoPutResultSet,
Cloneable {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private ResultDescription resultDescription;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this(transactionController, execRowArray, resultDescription, bl, false, 0L, temporaryRowHolderImpl);
    }

    public TemporaryRowHolderResultSet(TransactionController transactionController, ExecRow[] execRowArray, ResultDescription resultDescription, boolean bl, boolean bl2, long l, TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.tc = transactionController;
        this.rowArray = execRowArray;
        this.resultDescription = resultDescription;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = bl;
        this.isAppendable = bl2;
        this.positionIndexConglomId = l;
        this.holder = temporaryRowHolderImpl;
    }

    public void reset(ExecRow[] execRowArray) {
        this.rowArray = execRowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
    }

    public void reStartScan(long l, long l2) throws StandardException {
        if (this.isAppendable) {
            this.positionIndexConglomId = l2;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    public static TemporaryRowHolderResultSet getNewRSOnCurrentRow(Activation activation, CursorResultSet cursorResultSet) throws StandardException {
        TemporaryRowHolderImpl temporaryRowHolderImpl = new TemporaryRowHolderImpl(activation, null, cursorResultSet.getResultDescription());
        temporaryRowHolderImpl.insert(cursorResultSet.getCurrentRow());
        return (TemporaryRowHolderResultSet)temporaryRowHolderImpl.getResultSet();
    }

    public void markAsTopResultSet() {
    }

    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.getTemporaryConglomId() == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.getTemporaryConglomId(), false, 0, 7, 5, null, null, 0, null, null, 0);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow.getRowArray());
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long l) throws StandardException {
        if (this.holder.getTemporaryConglomId() == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(l);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[]{new SQLLongint(l)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, dataValueDescriptorArray, 1, null, null, -1);
        } else {
            this.indexsc.reopenScan(dataValueDescriptorArray, 1, null, null, -1);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation rowLocation = (RowLocation)this.indexRow[1];
        boolean bl = this.heapCC.fetch(rowLocation, this.currentRow.getRowArray(), null);
        ++this.numRowsOut;
        return this.currentRow;
    }

    public int getPointOfAttachment() {
        return -1;
    }

    public int getScanIsolationLevel() {
        return 5;
    }

    public void setTargetResultSet(TargetResultSet targetResultSet) {
    }

    public void setNeedsRowLocation(boolean bl) {
    }

    public double getEstimatedRowCount() {
        return 0.0;
    }

    public int resultSetNumber() {
        return 0;
    }

    public void setCurrentRow(ExecRow execRow) {
        this.currentRow = execRow;
    }

    public void clearCurrentRow() {
        this.currentRow = null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public RowLocation getRowLocation() {
        return null;
    }

    public void close() throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
    }

    public boolean returnsRows() {
        return true;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void open() throws StandardException {
        this.openCore();
    }

    public ExecRow getAbsoluteRow(int n) throws StandardException {
        return null;
    }

    public ExecRow getRelativeRow(int n) throws StandardException {
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        return null;
    }

    public ExecRow getFirstRow() throws StandardException {
        return null;
    }

    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        return null;
    }

    public boolean checkRowPosition(int n) {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        this.close();
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finished = true;
        this.close();
    }

    public long getExecuteTime() {
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    public long getTimeSpent(int n) {
        return 0L;
    }

    public NoPutResultSet[] getSubqueryTrackingArray(int n) {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    public boolean requiresRelocking() {
        return false;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        return null;
    }

    public boolean needsToClone() {
        return false;
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return false;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
    }

    public void positionScanAtRowLocation(RowLocation rowLocation) throws StandardException {
    }

    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
    }

    public void markRowAsDeleted() throws StandardException {
    }

    public final Activation getActivation() {
        return this.holder.activation;
    }
}

