/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.peoplematter.transformers;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.peoplematter.model.HashValue;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.TemplateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeopleMatterHashTransformer
extends AbstractMessageTransformer {
    private List<HashValue> hashValues;
    private String salt;
    protected final TemplateParser.PatternInfo patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    protected ExpressionManager expressionManager;

    public void initialise() throws InitialisationException {
        super.initialise();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        MessageDigest md = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this.salt);
        for (HashValue hv : this.hashValues) {
            String expression = hv.getValue();
            Object evaluatedValue = expression.startsWith(this.patternInfo.getPrefix()) && expression.endsWith(this.patternInfo.getSuffix()) ? this.expressionManager.evaluate(expression, message) : this.expressionManager.parse(expression, message);
            String result = "";
            if (evaluatedValue == null) {
                result = "";
            } else if (evaluatedValue instanceof String) {
                result = (String)evaluatedValue;
            } else {
                Transformer transformer = this.muleContext.getRegistry().lookupTransformer(DataTypeFactory.create(evaluatedValue.getClass()), DataType.STRING_DATA_TYPE);
                if (transformer != null) {
                    result = (String)transformer.transform(evaluatedValue);
                }
            }
            sb.append(result.trim());
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] sha1hash = new byte[40];
        try {
            md.update(sb.toString().getBytes("UTF-16LE"), 0, sb.toString().length() * 2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sha1hash = md.digest();
        return PeopleMatterHashTransformer.convertToHex(sha1hash);
    }

    public List<HashValue> getHashValues() {
        return this.hashValues;
    }

    public void setHashValues(List<HashValue> hashValues) {
        this.hashValues = hashValues;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }
}

