
package org.mule.modules.salesforce.adapters;

import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;
import org.mule.api.context.MuleContextAware;
import org.mule.api.store.ObjectStoreManager;
import org.mule.modules.salesforce.SalesforceModule;


/**
 * A <code>SalesforceModuleInjectionAdapter</code> is a wrapper around {@link SalesforceModule } that allows the injection of several Mule facilities when a MuleContext is set.
 * 
 */
public class SalesforceModuleInjectionAdapter
    extends SalesforceModuleLifecycleAdapter
    implements MuleContextAware
{


    @Override
    public void setMuleContext(MuleContext context) {
        super.setObjectStoreManager(((ObjectStoreManager) context.getRegistry().get(MuleProperties.OBJECT_STORE_MANAGER)));
    }

}
